# 文件下载器

一个基于Vue 3的现代化下载器应用，支持从Excel文件批量下载文件，具有类似迅雷的功能。

## 主要功能

- 🔐 **用户认证**: 登录系统，保护下载功能
- 📊 **Excel解析**: 支持灵活的Excel格式，可自定义文件名和URL列
- 📁 **文件名前缀**: 为所有下载文件添加自定义前缀
- 📄 **多列组合**: 支持多列组合生成文件名，用"-"分隔
- 📋 **分页显示**: 下载列表分页显示，默认每页10条
- ⚡ **批量操作**: 支持批量开始、暂停、删除下载
- 🔄 **断点续传**: 支持暂停和恢复下载
- 🚀 **多线程下载**: 防止界面卡顿
- 📱 **响应式设计**: 适配不同屏幕尺寸
- 🔔 **下载通知**: 下载完成后通知用户
- 🎯 **按页下载**: 支持只下载当前页面的文件
- 🎛️ **状态筛选**: 按下载状态筛选文件
- 🛠️ **智能操作**: 根据文件状态智能显示操作按钮

## 技术栈

- **前端框架**: Vue 3 (Composition API)
- **状态管理**: Pinia
- **UI组件库**: Element Plus
- **路由管理**: Vue Router
- **Excel解析**: SheetJS (xlsx)
- **HTTP客户端**: XMLHttpRequest (支持断点续传)
- **样式**: CSS3 + Element Plus主题

## 安装和运行

### 环境要求
- Node.js 16+
- npm 或 yarn

### 安装依赖
```bash
npm install
```

### 启动开发服务器
```bash
npm run dev
```

### 构建生产版本
```bash
npm run build
```

## 使用说明

### 1. 用户登录
- 默认用户名: `admin`
- 默认密码: `123456`

### 2. Excel文件格式
支持任意格式的Excel文件，用户可自定义：
- **文件名列**: 可选择多列，用"-"连接
- **URL列**: 选择包含下载链接的列

### 3. 下载设置
- **文件名前缀**: 为所有下载文件添加前缀（如：`vue-downloader_文件名.pdf`）
- **并发数**: 控制同时下载的文件数量
- **通知设置**: 下载完成后显示通知

### 4. 下载管理
- **单个操作**: 开始、暂停、恢复、删除单个文件
- **批量操作**: 批量开始、暂停、删除选中的文件
- **按页操作**: 下载或暂停当前页面的所有文件
- **状态筛选**: 按状态筛选文件（等待中、下载中、已暂停、已完成、错误）

### 5. 高级功能
- **断点续传**: 支持暂停后继续下载
- **自动重试**: 下载失败时自动重试
- **进度显示**: 实时显示下载进度和速度
- **文件扩展名**: 自动从URL提取文件扩展名

## 功能特性

### 文件名前缀
- 支持为所有下载文件添加自定义前缀
- 格式：`前缀_原文件名.扩展名`
- 示例：设置前缀为"vue-downloader"，文件"document.pdf"将保存为"vue-downloader_document.pdf"

### 多线程下载
- 控制并发下载数量，防止界面卡顿
- 默认最大并发数：3个
- 可自定义调整并发数

### 断点续传
- 支持暂停下载后继续
- 使用HTTP Range头实现
- 自动保存下载进度

### 智能操作
- 只有"下载中"状态的文件可以暂停
- 只有"已暂停"状态的文件可以恢复
- "已完成"和"等待中"状态的文件不受影响

### 状态筛选
- 支持按状态筛选：等待中、下载中、已暂停、已完成、错误
- 筛选后分页显示
- 支持按页操作

## 浏览器兼容性

### 现代浏览器（Chrome 86+, Edge 86+）
- ✅ 支持File System Access API
- ✅ 自动文件名前缀
- ✅ 完整的下载功能

### 传统浏览器
- ✅ 降级到传统下载方法
- ✅ 文件名前缀功能
- ✅ 基本下载功能

## 项目结构

```
src/
├── components/          # 组件
├── views/              # 页面
│   ├── Login.vue       # 登录页面
│   └── Downloader.vue  # 下载器主页面
├── stores/             # 状态管理
│   ├── auth.js         # 认证状态
│   └── download.js     # 下载状态
├── router/             # 路由配置
│   └── index.js
├── style.css           # 全局样式
└── main.js             # 应用入口
```

## 开发说明

### 状态管理
使用Pinia进行状态管理：
- `auth` store: 管理用户认证状态
- `download` store: 管理下载任务和设置

### 下载逻辑
- 使用XMLHttpRequest实现断点续传
- 支持暂停、恢复、取消操作
- 自动重试机制
- 进度和速度计算

### 文件处理
- 使用SheetJS解析Excel文件
- 支持多种Excel格式
- 自动提取文件扩展名

## 许可证

MIT License
