import { defineConfig } from 'vite'
import vue from '@vitejs/plugin-vue'
import { resolve } from 'path'

export default defineConfig({
  plugins: [vue()],
  resolve: {
    alias: {
      '@': resolve(__dirname, 'src')
    }
  },
  server: {
    port: 3000,
    open: true,
    proxy: {
      '/api': {
        target: 'https://downloader.rongketech.com/api',
        changeOrigin: true,
        rewrite: path => path.replace(/^\/api/, '')
      },
      '/other-api': {
        target: 'http://39.107.245.37:8081',
        changeOrigin: true,
        rewrite: path => path.replace(/^\/other-api/, '')
      }
    },
    
  },
  build: {
    outDir: 'dist',
    assetsDir: 'assets'
  }
})
