# 功能更新说明

## 新增功能

### 1. 状态筛选功能
- **位置**：下载任务管理页面顶部
- **功能**：可以按下载状态筛选显示的任务
- **筛选选项**：
  - 全部
  - 等待中
  - 下载中
  - 已暂停
  - 已完成
  - 失败

### 2. 智能操作控制
根据任务状态，只有特定状态的任务可以执行相应操作：

#### 开始下载
- **可操作状态**：等待中、已暂停、失败
- **按钮显示**：状态为"等待中"时显示"开始"按钮
- **批量操作**：只对可开始下载的任务生效

#### 暂停下载
- **可操作状态**：仅下载中
- **按钮显示**：状态为"下载中"时显示"暂停"按钮
- **批量操作**：只对正在下载的任务生效

#### 继续下载
- **可操作状态**：仅已暂停
- **按钮显示**：状态为"已暂停"时显示"继续"按钮
- **功能**：支持断点续传

#### 重试下载
- **可操作状态**：仅失败
- **按钮显示**：状态为"失败"时显示"重试"按钮

#### 删除任务
- **可操作状态**：所有状态
- **按钮显示**：始终显示"删除"按钮

## 操作逻辑

### 批量开始选中
1. 检查选中的任务
2. 过滤出可以开始下载的任务（等待中、已暂停、失败）
3. 如果过滤后没有可操作任务，显示警告
4. 只对可操作的任务执行下载

### 批量暂停选中
1. 检查选中的任务
2. 过滤出正在下载的任务
3. 如果过滤后没有可操作任务，显示警告
4. 只对可操作的任务执行暂停

### 下载当前页
1. 获取当前页所有任务
2. 过滤出可以开始下载的任务
3. 如果过滤后没有可操作任务，显示警告
4. 只对可操作的任务执行下载

### 暂停当前页
1. 获取当前页所有任务
2. 过滤出正在下载的任务
3. 如果过滤后没有可操作任务，显示警告
4. 只对可操作的任务执行暂停

## 状态说明

### 等待中 (pending)
- 任务已添加但未开始下载
- 可以执行：开始下载、删除

### 下载中 (downloading)
- 任务正在下载中
- 可以执行：暂停、删除
- 显示下载进度和速度

### 已暂停 (paused)
- 任务已暂停，支持断点续传
- 可以执行：继续下载、删除
- 保留已下载的进度

### 已完成 (completed)
- 任务下载完成
- 可以执行：删除
- 显示100%进度

### 失败 (error)
- 任务下载失败
- 可以执行：重试、删除
- 显示错误信息

## 使用示例

### 场景1：筛选查看失败的任务
1. 在状态筛选下拉框中选择"失败"
2. 页面只显示失败的任务
3. 可以批量选择失败任务进行重试

### 场景2：暂停所有正在下载的任务
1. 在状态筛选下拉框中选择"下载中"
2. 页面只显示正在下载的任务
3. 点击"下载当前页"按钮暂停所有任务

### 场景3：批量重试失败的任务
1. 在状态筛选下拉框中选择"失败"
2. 选择需要重试的任务
3. 点击"批量开始选中"按钮

## 技术实现

### 状态筛选
```javascript
const filteredDownloads = computed(() => {
  return downloadStore.downloads.filter(item => {
    if (statusFilter.value) {
      return item.status === statusFilter.value
    }
    return true
  })
})
```

### 智能操作过滤
```javascript
// 过滤可开始下载的任务
const startableItems = selectedItems.value.filter(item => 
  ['pending', 'paused', 'error'].includes(item.status)
)

// 过滤可暂停的任务
const pausableItems = selectedItems.value.filter(item => 
  item.status === 'downloading'
)
```

### 分页适配
- 分页基于筛选后的数据
- 筛选后自动回到第一页
- 总数显示筛选后的数量

## 用户体验改进

1. **智能提示**：当没有可操作任务时，显示具体的警告信息
2. **状态一致性**：确保操作按钮与任务状态匹配
3. **批量操作优化**：只对符合条件的任务执行操作
4. **筛选功能**：快速定位特定状态的任务
5. **断点续传**：暂停的任务可以从中断点继续下载

## 浏览器兼容性

- 支持所有现代浏览器
- 状态筛选功能基于前端计算，无需后端支持
- 断点续传功能使用HTTP Range头部，兼容性好
