"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const graphql_1 = require("graphql");
const utils_1 = require("../../utils");
exports.keyFieldsMissingOnBase = ({ schema, }) => {
    const errors = [];
    const types = schema.getTypeMap();
    for (const [typeName, namedType] of Object.entries(types)) {
        if (!graphql_1.isObjectType(namedType))
            continue;
        if (namedType.federation && namedType.federation.keys) {
            const allFieldsInType = namedType.getFields();
            for (const [serviceName, selectionSets] of Object.entries(namedType.federation.keys)) {
                for (const selectionSet of selectionSets) {
                    for (const field of selectionSet) {
                        const name = field.name.value;
                        const matchingField = allFieldsInType[name];
                        if (matchingField) {
                            if (matchingField.federation &&
                                matchingField.federation.serviceName) {
                                errors.push(utils_1.errorWithCode('KEY_FIELDS_MISSING_ON_BASE', utils_1.logServiceAndType(serviceName, typeName) +
                                    `A @key selects ${name}, but ${typeName}.${name} was either created or overwritten by ${matchingField.federation.serviceName}, not ${serviceName}`));
                            }
                        }
                    }
                }
            }
        }
    }
    return errors;
};
//# sourceMappingURL=keyFieldsMissingOnBase.js.map