"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("apollo-server-env");
const graphql_1 = require("graphql");
const utils_1 = require("../../utils");
exports.executableDirectivesIdentical = ({ schema, }) => {
    const errors = [];
    const customDirectives = schema
        .getDirectives()
        .filter(x => !utils_1.isFederationDirective(x) && !graphql_1.isSpecifiedDirective(x));
    customDirectives.forEach(directive => {
        if (!directive.federation)
            return;
        const definitions = Object.entries(directive.federation.directiveDefinitions);
        const shouldError = definitions.some(([, definition], index) => {
            if (index === 0)
                return;
            const [, previousDefinition] = definitions[index - 1];
            return !utils_1.typeNodesAreEquivalent(definition, previousDefinition);
        });
        if (shouldError) {
            errors.push(utils_1.errorWithCode('EXECUTABLE_DIRECTIVES_IDENTICAL', utils_1.logDirective(directive.name) +
                `custom directives must be defined identically across all services. See below for a list of current implementations:\n${definitions
                    .map(([serviceName, definition]) => {
                    return `\t${serviceName}: ${graphql_1.print(definition)}`;
                })
                    .join('\n')}`));
        }
    });
    return errors;
};
//# sourceMappingURL=executableDirectivesIdentical.js.map