"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("apollo-server-env");
const graphql_1 = require("graphql");
const utils_1 = require("../../utils");
exports.executableDirectivesInAllServices = ({ schema, serviceList, }) => {
    const errors = [];
    const customExecutableDirectives = schema
        .getDirectives()
        .filter(x => !utils_1.isFederationDirective(x) && !graphql_1.isSpecifiedDirective(x));
    customExecutableDirectives.forEach(directive => {
        if (!directive.federation)
            return;
        const allServiceNames = serviceList.map(({ name }) => name);
        const serviceNamesWithDirective = Object.keys(directive.federation.directiveDefinitions);
        const serviceNamesWithoutDirective = allServiceNames.reduce((without, serviceName) => {
            if (!serviceNamesWithDirective.includes(serviceName)) {
                without.push(serviceName);
            }
            return without;
        }, []);
        if (serviceNamesWithoutDirective.length > 0) {
            errors.push(utils_1.errorWithCode('EXECUTABLE_DIRECTIVES_IN_ALL_SERVICES', utils_1.logDirective(directive.name) +
                `Custom directives must be implemented in every service. The following services do not implement the @${directive.name} directive: ${serviceNamesWithoutDirective.join(', ')}.`));
        }
    });
    return errors;
};
//# sourceMappingURL=executableDirectivesInAllServices.js.map