"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const graphql_1 = require("graphql");
const utils_1 = require("../../utils");
exports.requiresUsedOnBase = ({ name: serviceName, typeDefs, }) => {
    const errors = [];
    graphql_1.visit(typeDefs, {
        ObjectTypeDefinition(typeDefinition) {
            if (typeDefinition.fields) {
                for (const field of typeDefinition.fields) {
                    if (field.directives) {
                        for (const directive of field.directives) {
                            const name = directive.name.value;
                            if (name === 'requires') {
                                errors.push(utils_1.errorWithCode('REQUIRES_USED_ON_BASE', utils_1.logServiceAndType(serviceName, typeDefinition.name.value, field.name.value) +
                                    `Found extraneous @requires directive. @requires cannot be used on base types.`));
                            }
                        }
                    }
                }
            }
        },
    });
    return errors;
};
//# sourceMappingURL=requiresUsedOnBase.js.map