import { flags as F } from '@oclif/command';
export declare function table<T extends object>(data: T[], columns: table.Columns<T>, options?: table.Options): void;
export declare namespace table {
    const Flags: {
        columns: F.IOptionFlag<string | undefined>;
        sort: F.IOptionFlag<string | undefined>;
        filter: F.IOptionFlag<string | undefined>;
        csv: import("@oclif/parser/lib/flags").IBooleanFlag<boolean>;
        extended: import("@oclif/parser/lib/flags").IBooleanFlag<boolean>;
        'no-truncate': import("@oclif/parser/lib/flags").IBooleanFlag<boolean>;
        'no-header': import("@oclif/parser/lib/flags").IBooleanFlag<boolean>;
    };
    type IFlags = typeof Flags;
    type ExcludeFlags<T, Z> = Pick<T, Exclude<keyof T, Z>>;
    type IncludeFlags<T, K extends keyof T> = Pick<T, K>;
    function flags(): IFlags;
    function flags<Z extends keyof IFlags = keyof IFlags>(opts: {
        except: Z | Z[];
    }): ExcludeFlags<IFlags, Z>;
    function flags<K extends keyof IFlags = keyof IFlags>(opts: {
        only: K | K[];
    }): IncludeFlags<IFlags, K>;
    type Columns<T extends object> = {
        [key: string]: Partial<Column<T>>;
    };
    interface Column<T extends object> {
        header: string;
        extended: boolean;
        minWidth: number;
        get(row: T): any;
    }
    interface Options {
        [key: string]: any;
        sort?: string;
        filter?: string;
        columns?: string;
        extended?: boolean;
        'no-truncate'?: boolean;
        csv?: boolean;
        'no-header'?: boolean;
        printLine?(s: any): any;
    }
}
