var system = require("../../../system")
const settings = require("../../../../config/settings")
const CtlBase = require("../../ctlms.base");
const md5 = require("MD5");
const uuidv4 = require('uuid/v4');
const logCtl = system.getObject("web.common.oplogCtl");

class MerchantaccountCtl extends CtlBase {
    constructor() {
        super();
        this.merchantaccountSve = system.getObject("service.merchant.merchantaccountSve");
    }

    async reduceAccountBalance(params, pobj2, req) {
        try {
            return await this.merchantSve.reduceAccountBalance(params);
        } catch (error) {
            return system.getResult(null, `系统错误 错误信息 ${error}`);
        }
    }

    async addordelavailable(params, pobj2, req) {
        try {
            return await this.merchantSve.addordelavailable(params);
        } catch (error) {
            return system.getResult(null, `系统错误 错误信息 ${error}`);
        }
    }


}

module.exports = MerchantaccountCtl;
