var system = require("../../../system")
const settings = require("../../../../config/settings")
const CtlBase = require("../../ctlms.base");
const md5 = require("MD5");
const uuidv4 = require('uuid/v4');
const logCtl = system.getObject("web.common.oplogCtl");

class MerchantUserCtl extends CtlBase {
    constructor() {
        super();
        this.merchanttradeSve = system.getObject("service.merchant.merchanttradeSve");
    }


    async merchanttradesOfList(params, pobj2, req) {
        try {
            return await this.merchanttradeSve.merchanttradesOfList(params);
        } catch (error) {
            return system.getResult(null, `系统错误 错误信息 ${error}`);
        }
    }

    //调账添加
    async addMerchanttrades(params, pobj2, req) {
        try {
            return await this.merchanttradeSve.addMerchanttrades(params);
        } catch (error) {
            return system.getResult(null, `系统错误 错误信息 ${error}`);
        }
    }

    //充值审核
    async auditMerchanttrade(params, pobj2, req) {
        try {
            params.audit_user_id = req.loginUser.id;
            return await this.merchanttradeSve.auditMerchanttrade(params);
        } catch (error) {
            return system.getResult(null, `系统错误 错误信息 ${error}`);
        }
    }

    //资金流水
    async merchanttradesOfListAll(params, pobj2, req) {
        try {
            return await this.merchanttradeSve.merchanttradesOfListAll(params);
        } catch (error) {
            return system.getResult(null, `系统错误 错误信息 ${error}`);
        }
    }

    //代客下单流水
    async valetorder(params, pobj2, req) {
        try {
            return await this.merchanttradeSve.valetorder(params);
        } catch (error) {
            return system.getResult(null, `系统错误 错误信息 ${error}`);
        }
    }





}

module.exports = MerchantUserCtl;
