const CacheBase = require("../cache.base");
const system = require("../../system");
const settings = require("../../../config/settings");
//缓存首次登录的赠送的宝币数量
class ApiUserCache extends CacheBase {
  constructor() {
    super();
    this.restS = system.getObject("util.restClient");
  }
  desc() {
    return "应用中来访访问token缓存";
  }
  prefix() {
    return settings.cacheprefix + "_userdata:";
  }
  async buildCacheVal(cachekey, inputkey, val, ex, ...items) {
    var cacheManager = system.getObject("db.common.cacheManager");
    //当来访key缓存不存在时,需要去开放平台检查是否存在来访key缓存
    var acckapp = await cacheManager["ApiAccessKeyCache"].cache(settings.appKey, null, ex);//先获取本应用accessKey
    var checkresult = await this.restS.execPostWithAK({ checkAccessKey: inputkey }, settings.paasUrl() + "api/auth/accessAuth/authAccessKey", acckapp.accessKey);
    if (checkresult.status == 0) {
      var s = checkresult.data;
      return JSON.stringify(s);
    } else {
      await cacheManager["ApiAccessKeyCache"].invalidate(settings.appKey);
      var acckapp = await cacheManager["ApiAccessKeyCache"].cache(settings.appKey, null, ex);//先获取本应用accessKey
      var checkresult = await this.restS.execPostWithAK({ checkAccessKey: inputkey }, settings.paasUrl() + "api/auth/accessAuth/authAccessKey", acckapp.accessKey);
      var s = checkresult.data;
      return JSON.stringify(s);
    }

  }
}
module.exports = ApiUserCache;
