const system = require("../../../system");
const ServiceBase = require("../../svems.base")

class UserService extends ServiceBase {
    constructor() {
        super();
    }

    /**
     * fn:保存订单
     * @param params
     * @returns {Promise<{msg: *, data, bizmsg: *|string, status: number}|any|undefined>}
     */
    async saveEorder(params) {
        return await this.callms("sve_order", "saveEorder", params);
    }

    /**
     * fn:审核订单
     * @param params
     * @returns {Promise<{msg: *, data, bizmsg: *|string, status: number}|any|undefined>}
     */
    async auditEorder(params) {
        return await this.callms("sve_order", "auditEorder", params);
    }

    /**
     * fn:根据ID查看订单
     * @param params
     * @returns {Promise<{msg: *, data, bizmsg: *|string, status: number}|any|undefined>}
     */
    async getEorderById(params) {
        return await this.callms("sve_order", "getEorderById", params);
    }

    /**
     * fn:查看订单列表(分页)
     * @param params
     * @returns {Promise<{msg: *, data, bizmsg: *|string, status: number}|any|undefined>}
     */
    async pageEorder(params) {
        return await this.callms("sve_order", "pageEorder", params);
    }

    /**
     * fn:更爱订单状态
     * @param params
     * @returns {Promise<{msg: string, data, bizmsg: *|string, status: number}|any|undefined>}
     */
    async updEorderStatus(params) {
        return await this.callms("sve_order", "updEorderStatus", params);
    }

    /**
     * fn:更新订单（单表更新）
     * @param params
     * @returns {Promise<void>}
     */
    async updOrderSimple(params){
        return await this.callms("sve_order", "updOrderSimple", params);
    }




}

module.exports = UserService;