const system = require("../../../system");
const ServiceBase = require("../../svems.base")

class UserService extends ServiceBase {
    constructor() {
        super();
    }

    /**
     * fn:根据产品ID查询最早创建的订单
     * ps:当前商户下如果存在 单个商品和组合商品 都包涵 同样的子产品 ，在实际消费的时候 应该扣除最先创建订单的子产品(订单的状态 生效中)
     * @param params
     * @returns {Promise<void>}
     */
    async listEorderProduct(params){
        return await this.callms("sve_order", "listEorderProduct", params);
    }

    /**
     * fn:fn:查看当前商户下所有的订单相关的产品（没有分页）
     * @param params
     * @returns {Promise<{msg: string, data, bizmsg: *|string, status: number}|*|undefined>}
     */
    async listEorderProductByMerchantId(params){
        return await this.callms("sve_order", "listEorderProductByMerchantId", params);
    }

}

module.exports = UserService;