const system = require("../../../system");
const ServiceBase = require("../../svems.base")

class UserService extends ServiceBase {
  constructor() {
    super();
  }

  async saveAdminUser(params) {
    try {
      return await this.callms("sve_uc", "saveAdminUser", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async saveMerchantUser(params) {
    try {
      return await this.callms("sve_uc", "saveMerchantUser", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async login(params) {
    try {
      return await this.callms("sve_uc", "adminLogin", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }
  
  async page(params) {
    try {
      return await this.callms("sve_uc", "userPage", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async info(params) {
    try {
      return await this.callms("sve_uc", "userInfo", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async enabled(params) {
    try {
      return await this.callms("sve_uc", "userEnabled", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async mapByIds(params) {
    try {
      return await this.callms("sve_uc", "userMapByIds", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }
}

module.exports = UserService;