const path = require('path');
const os = require('os');
var ENVINPUT = {
  DB_HOST: process.env.DB_HOST,
  DB_PORT: process.env.DB_PORT,
  DB_USER: process.env.DB_USER,
  DB_PWD: process.env.DB_PWD,
  REDIS_HOST: process.env.REDIS_HOST,
  REDIS_PORT: process.env.REDIS_PORT,
  REDIS_PWD: process.env.REDIS_PWD,
  DB_NAME: process.env.ESIGNADMIN_DB_NAME,
  REDIS_DB: process.env.ESIGNADMIN_REDIS_DB,
  APP_ENV: process.env.APP_ENV ? process.env.APP_ENV : "dev"
};

var settings = {
  env: ENVINPUT.APP_ENV,
  platformid: 1,
  platformcompanyid: 1,
  commonroleid: 1,
  passroleid: 2,
  tanentroleid: 1,
  protocalPrefix: "http://",

  appKey: ENVINPUT.APP_ENV == "dev" ? "2f41920e82fa46dd98887d81df9457ab" : "728b979f7afd4413ac683344cd4a97fa",
  secret: ENVINPUT.APP_ENV == "dev" ? "ede9b66ddb964d15b0a543b7ac7bb28f" : "f8891fcf37574f5a9f21b3030c302f4a",

  salt: "%iatpD1gcxz7iF#B",
  defaultpwd: "987456",
  basepath: path.normalize(path.join(__dirname, '../..')),
  port: process.env.NODE_PORT || 3601,
  localpath: function () {
    let platform = os.platform() || "";
    // windows
    if (platform.toLocaleLowerCase().startsWith('win')) {
      return "d:/tmp/"
    } else {
      return "/tmp/"
    }
  },
  reqEsAddr: function () {
    if (this.env == "dev") {
      var localsettings = require("./localsettings");
      return "http://43.247.184.94:7200/"; //localsettings.reqEsDevUrl;
    } else {
      return "http://43.247.184.94:7200/";
    }
  },
  paasUrl: function () {
    if (this.env == "dev") {
      return "http://192.168.18.237:4001/";
      // return "http://192.168.18.125:4001/";
    } else {
      return "https://open.gongsibao.com/";
    }
  },
  apiconfig: {
    opLogUrl: function () {
      return settings.reqEsAddr() + "bigdata_zc_op_log/_doc?pretty";
    },
    opLogEsIsAdd: function () {
      return 1;
    },
    AES: {
      key: "qUPsMflPfgpPP1Ua", //密钥
      iv: '1012133205963708', //偏移向量
      padding: 'PKCS7Padding' //补全值
    }
  },
  indexPage: function() {
    if(this.env == "dev") {
      // return "http://localhost:8080";
      return "https://xggadmin.gongsibao.com";
    } else {
      return "https://xggadmin.gongsibao.com";
    }
  },
  homePage: function () {
    if (this.env == "dev") {
      var localsettings = require("./localsettings");
      return localsettings.reqHomePageDevUrl;
    } else {
      return "https://open.gongsibao.com/";
    }
  },
  authUrl: function () {
    if (this.env == "dev") {
      var localsettings = require("./localsettings");
      return localsettings.reqAuthUrl;
    } else {
      return "https://open.gongsibao.com/auth";
    }
  },
  docUrl: function () {
    if (this.env == "dev") {
      var localsettings = require("./localsettings");
      return localsettings.docUrl;
    } else {
      return "https://open.gongsibao.com/web/common/metaCtl/getApiDoc";
    }
  },
  ntapi: function () {
    let domain = "";
    let domain_page = "";
    if (this.env == "dev") {
      domain = "https://nt-api.gongsibao.com";
      domain_page = "https://nt.gongsibao.com";
    } else {
      domain = "https://nga-api.gongsibao.com";
      domain_page = "https://nga.gongsibao.com";
    }

    return {  
      // 税务登录地址
      taxLoginUrl: domain_page + "/web/auth",
      // 财务地址
      finLoginUrl: domain_page + "/web/auth",
      // 创建交付商&管理员
      synUserDetails: domain + "/nga-api/synUserDetails",
      // 交付商启用/禁用
      updateCompanyStatus: domain + "/nga-api/company/updateCompanyStatus",
      // 建账
      createCustomer: domain + "/nga-api/createCustomer",
      // 查询账户信息
      getCustomerById: domain + "/nga-api/getCustomerById",
      // 上传发票
      uploadDetail: domain + "/nga-api/uploadDetail",
      // 月报表
      getReportData: domain + "/nga-api/report/getReportData",
      // 季报表
      getReportDataQuarter: domain + "/nga-api/report/getReportDataQuarter",
    }
  },
  deliverSysApi: function () {
    let domain = "";
    if (this.env == "dev") {
      domain = "http://39.107.234.14:3012";
      // orderDomain= "http://39.107.234.14:3012";
      orderDomain= "http://127.0.0.1:3012";
    } else {
      domain = "https://xggadmin.gongsibao.com";
    }
    return {
      // 根据订单来源查询状态
      queryOrderStatusBySourceNo: orderDomain + "/web/order/orderCtl/queryOrderStatusBySourceNo",
      //发票是试算
      calcInvoice: domain + "/web/invoice/invoiceCtl/calcInvoice",
    }
  },
  redis: function () {
    if (this.env == "dev") {
      var localsettings = require("./localsettings");
      return localsettings.redis;
    } else {
      return {
        host: ENVINPUT.REDIS_HOST,
        port: ENVINPUT.REDIS_PORT,
        password: ENVINPUT.REDIS_PWD,
        db: ENVINPUT.REDIS_DB,
      };
    }
  },
  redisTax: function () {
    if (this.env == "dev") {
      return {
        host: "47.94.0.45",
        port: "6379",
        password: "nga2020",
        db: "0",
      };
    } else {
      return {
        host: "r-2zejem2xk438n71rny.redis.rds.aliyuncs.com",
        port: "6379",
        password: "yo#@eXz9EMpa+5O",
        db: "0",
      };
    }
  },
  database: function () {
    if (this.env == "dev") {
      var localsettings = require("./localsettings");
      return localsettings.database;
    } else {
      return {
        dbname: ENVINPUT.DB_NAME,
        user: ENVINPUT.DB_USER,
        password: ENVINPUT.DB_PWD,
        config: {
          host: ENVINPUT.DB_HOST,
          dialect: 'mysql',
          operatorsAliases: false,
          pool: {
            max: 5,
            min: 0,
            acquire: 90000000,
            idle: 1000000
          },
          debug: false,
          dialectOptions: {
            requestTimeout: 999999,
            // instanceName:'DEV'
          } //设置MSSQL超时时间
        },
      };
    }
  }
};
settings.ENVINPUT = ENVINPUT;
module.exports = settings;