#!/usr/bin/env python
# -*- coding: utf-8 -*-
from flask import request
from common.crm_change_standard import getStandardName
import json
from service.Dataoper import Datao
from dao.trade_es import trade_Es



def selectcyle(server):
    @server.route("/api/selectcycle",methods = ['POST'])
    def getCompanyTrade():
        try:
            companyNames=request.get_json().get("company_name")
            trade_Info = trade_Es()
            standard_company_name = getStandardName(companyNames)
            searched = trade_Info.Get_Data_By_Body(standard_company_name)
            if searched["hits"]["total"]:
                company_cate_1 = searched["hits"]["hits"][0]['_source']["gsb_company_cate_1"]  # 行业第一大类
                company_cate_2 = searched["hits"]["hits"][0]['_source']["gsb_company_cate_2"]  # 行业第二大类
                company_cate_3 = searched["hits"]["hits"][0]['_source']["gsb_company_cate_3"]  # 行业第三大类
                establishment_time = searched["hits"]["hits"][0]['_source']["estiblish_time"]  # 成立时间
                DataoperInfo = Datao()
                re1,re2 = DataoperInfo.Getdata(company_cate_1,establishment_time)
                if re1:
                    return json.dumps({"status": 0, "msg":"操作成功","data": re2}, ensure_ascii=False)
                else:
                    return json.dumps({"status": -1, "msg":"没有对应的证照信息","data": []}, ensure_ascii=False)
            else:
                return json.dumps({"status": -1, "msg":"没有对应工商信息","data": []}, ensure_ascii=False)
        except:
            return json.dumps({"status": -1, "msg":"调用服务出错","data": []}, ensure_ascii=False)

def insertcycle(server):
    @server.route("/api/insertcycle",methods = ['POST'])
    def putCompanyTrade():
        try:
            data=request.get_json().get("data")
            print(data)
            DataoperInfo = Datao()
            re1=DataoperInfo.InsertData(data)
            if re1 :
                return json.dumps({"status": 0, "msg":"成功","data": re1}, ensure_ascii=False)
            else:
                return json.dumps({"status": -1, "msg":"失败","data": 0}, ensure_ascii=False)
        except:
            return json.dumps({"status": -1, "msg":"调用服务出错","data": {}}, ensure_ascii=False)