#!/usr/bin/env python
# -*- coding: utf-8 -*-
# @Time    : 2020/4/27 18:49
# @Author  : fanhui
# @File    : rec_status.py
# @Software: PyCharm

import json
from dao.re_status_dao import rec_status_Dao
from db.mod_db import DataBase
from flask import request


#更新状态表的结果
def WriteRecStatusToSql(recommend_id,status_name):
    # json写入数据库
    db_info = DataBase()
    try:
        rec_status = rec_status_Dao()
        rec_status.select_sql_1(recommend_id,status_name)
    except Exception as e:

        print(e)
        db_info.roll_back()
    # 关闭数据库连接
    # db_info.close()
    return "状态表已更新"

#更新状态表的结果
def WriteRecRemarksToSql(recommend_id,remarks):
    # json写入数据库
    db_info = DataBase()
    try:
        rec_status = rec_status_Dao()
        rec_status.select_sql_2(recommend_id,remarks)
    except Exception as e:

        print(e)
        db_info.roll_back()
    # 关闭数据库连接
    # db_info.close()
    return "状态表备注已更新"

def tj_rec_status(server):
    @server.route('/gsb/api/tj_rec_status', methods=['POST'])
    def tj_rec_status():
        print("接口调用--------更新状态表")
        if request.method == 'POST':
            try:
                # requestdata = request.values
                requestdata = request.json
                print(requestdata)
                recommend_id = requestdata.get('recommendId')
                status_name = requestdata.get('stateName')
                WriteRecStatusToSql(recommend_id, status_name)
                return json.dumps({"status": 0, "msg": "成功", "data": recommend_id}, ensure_ascii=False)
            except:
                return json.dumps({"status": -1, "msg": "失败", "data": {}}, ensure_ascii=False)

def tj_rec_remark(server):
    @server.route('/gsb/api/statusRemarks', methods=['POST'])
    def tj_rec_remark():
        print("接口调用--------更新状态表")
        if request.method == 'POST':
            try:
                # requestdata = request.values
                requestdata = request.json
                recommend_id = requestdata.get('recommendId')
                remarks = requestdata.get('remarks')
                WriteRecRemarksToSql(recommend_id, remarks)
                return json.dumps({"status": 0, "msg": "成功", "data": recommend_id}, ensure_ascii=False)
            except:
                return json.dumps({"status": -1, "msg": "失败", "data": {}}, ensure_ascii=False)

# server.run(host='127.0.0.1', port=19, debug=True)

