#!/usr/bin/env python
# -*- coding:utf-8 -*- 
# Author: hj
# softWare:pycharm
# fileName:mod_db.py
# createTime:2020/7/18 12:47

from __future__ import division
from db import mod_config
import pymysql

DB = "database"
DBNAME = mod_config.getConfig(DB, 'dbname')
DBHOST = mod_config.getConfig(DB, 'dbhost')
DBUSER = mod_config.getConfig(DB, 'dbuser')
DBPWD = mod_config.getConfig(DB, 'dbpassword')
DBCHARSET = mod_config.getConfig(DB, 'dbcharset')
DBPORT = mod_config.getConfig(DB, 'dbport')


# 数据库操作类
class Database:
    def __init__(self, dbname=None, dbhost=None):
        if dbname is None:
            self._dbname = DBNAME
        else:
            self._dbname = dbname
        if dbhost is None:
            self._dbhost = DBHOST
        else:
            self._dbhost = dbhost

        self._dbuser = DBUSER
        self._dbpassword = DBPWD
        self._dbcharset = DBCHARSET
        self._dbport = int(DBPORT)
        self._conn = self.connectMysql

        if (self._conn):
            self._cursor = self._conn.cursor()

    """数据库连接"""
    @property
    def connectMysql(self):
        try:
            conn = pymysql.connect(host=self._dbhost, user=self._dbuser, password=self._dbpassword, db=self._dbname,
                                   port=self._dbport, cursorclass=pymysql.cursors.DictCursor, charset=self._dbcharset,
                                   autocommit=True)
        except Exception as error:
            print('connect database failed ,%s'% error)
            conn = False
        return conn

    """获取查询结果"""
    def sqlResult(self,sql):
        res = ''
        if (self._conn):
            try:
                self._cursor.execute(sql)
                res = self._cursor.fetchall()
            except Exception as error:
                res = False
                print("query database exception,%s" % error)
        return res

    def sqlInsert(self,sql):
        flag = False
        if (self._conn):
            try:
                self._cursor.execute(sql)
                flag = True
                self._conn.commit()
            except Exception as error:
                flag = False
                print('insert database exception , %s' % error)
        return flag

    """关闭数据库"""
    def sqlClose(self):
        if (self._conn):
            try:
                if (type(self._cursor) == 'object'):
                    self._cursor.close()
                if (type(self._conn) == 'object'):
                    self._conn.close()
            except Exception as error:
                print('close database exception,%s'% error)

    def sqlRollback(self):
        if (self._conn):
            try:
                self._conn.rollback()
            except Exception as error:
                print('db rollback exception,%s' % error)

    def sqlCursor(self):
        return self._cursor

    def sqlConn(self):
        return self._conn





