#!/usr/bin/env python
# -*- coding:utf-8 -*- 
# Author: hj
# softWare:pycharm
# fileName:industry_info.py
# createTime:2020/7/19 15:58

from dao.ent_qualification import qualificationsDao
from flask import request



qualifications_info = qualificationsDao()

# 获取第一行业信息
def industryOne():
    industry_one_list = []
    industry_one_result = qualifications_info.industryOne()
    print('industry_one_result',industry_one_result)
    for row in industry_one_result:
        industry_one_dict = {}
        industry_one_dict["id"] = row["industry_one_code"]
        industry_one_dict["name"] = row["industry_one"]
        industry_one_list.append(industry_one_dict)
        # print(industry_one_list)
    return industry_one_list

# 获取第二行业信息
def industryTwo(industry_one_code):
    industry_two_list = []
    industry_two_result = qualifications_info.industryTwo(industry_one_code)
    for row in industry_two_result:
        industry_two_dict = {}
        industry_two_dict["id"] = row["industry_two_code"]
        industry_two_dict["name"] = str(row["industry_two"])
        industry_two_dict["isChoice"] = False
        industry_two_list.append(industry_two_dict)
    return industry_two_list


def industryOneRoute(server):
    @server.route('/gsb/api/industry_one',methods = ['POST'])
    def industryOneMain():
        if request.method == 'POST':
            result_dict = {}
            try:
                industry_one_list = industryOne()
                result_dict['data'] = industry_one_list
                result_dict['status'] = 0
                result_dict['msg'] = "success"
            except Exception as error:
                print("获取一级行业大类失败：",error)
                result_dict['data'] = str(error)
                result_dict['status'] = -1
                result_dict['msg'] = "failed"
            return result_dict

def industryTwoRoute(server):
    @server.route('/gsb/api/industry_two',methods = ['POST'])
    def industryTwoMain():
        if request.method == 'POST':
            result_dict = {}
            try:
                request_data = request.json
                print('request_data',request_data)
                industry_one_code = request_data['industryId']
                industry_two_list = industryTwo(industry_one_code)
                result_dict['data'] = industry_two_list
                result_dict['status'] = 0
                result_dict['msg'] = "success"
            except Exception as error:
                print("获取二级行业大类失败：",error)
                result_dict['data'] = str(error)
                result_dict['status'] = -1
                result_dict['msg'] = "failed"
            return result_dict
