#!/usr/bin/env python
# -*- coding:utf-8 -*- 
# Author: hj
# softWare:pycharm
# fileName:select_qualification.py
# createTime:2020/7/19 22:05
from qualifications_diagnosis.dao.ent_qualification import qualificationsDao
from flask import request

qualifications_info = qualificationsDao()

#根据信息查询资质信息
def qualificationsInfo(platform_code,export_label, store_type_code, industry_one_code,industry_two_code):
    data_dict = {}
    base_list = []
    brand_list = []
    industry_list = []

    base_alone = []
    brand_alone = []
    industry_alone = []

    qualifications_result = qualifications_info.selectQualifications(platform_code,export_label, store_type_code, industry_one_code,industry_two_code)
    print('qualifications_result',qualifications_result)
    if qualifications_result:
        for row in qualifications_result:
            qualification_type = row['qualification_type']
            if qualification_type == '企业资质':
                if row['qualification_comments'] not in base_alone:
                    base_alone.append(row['qualification_comments'])
                    base_dict = {}
                    base_dict["id"] = row['qualification_comments_code']
                    base_dict["name"] = row['qualification_comments']
                    base_dict['isChoice'] = False
                    if base_dict:
                        base_list.append(base_dict)
                    data_dict['base'] = base_list
            elif qualification_type == '品牌资质':
                if row['qualification_comments'] not in brand_alone:
                    brand_alone.append(row['qualification_comments'])
                    brand_dict = {}
                    brand_dict["id"] = row['qualification_comments_code']
                    brand_dict["name"] = row['qualification_comments']
                    brand_dict['isChoice'] = False
                    if brand_dict:
                        brand_list.append(brand_dict)
                    data_dict['brand'] = brand_list
            elif qualification_type == '行业资质':
                if row['qualification_comments'] not in industry_alone:
                    industry_alone.append(row['qualification_comments'])
                    industry_dict = {}
                    industry_dict["id"] = row['qualification_comments_code']
                    industry_dict["name"] = row['qualification_comments']
                    industry_dict['isChoice'] = False
                    if industry_dict:
                        industry_list.append(industry_dict)
                    data_dict['industry'] = industry_list
            else:
                print("资质列表信息错误")
                return "资质列表信息错误"
    else:
        data_dict['base'] = ['暂停接受入驻']
        data_dict['brand'] = ['暂停接受入驻']
        data_dict['industry'] = ['暂停接受入驻']
    return data_dict

def qualificationsRoute(server):
    @server.route('/gsb/api/qualifications',methods = ['POST'])
    def qualificationsMain():
        if request.method == 'POST':
            result_dict = {}
            try:
                request_data = request.json
                isImports = request_data['isImports']
                if isImports == False:
                    export_label = '0'
                else:
                    export_label = '1'
                platform_code = request_data['platformCode']
                store_type_code = request_data['storeTypeId']
                industry_one_code = request_data['industryId']
                secondIndustry = request_data['secondIndustry']
                industry_two_code = secondIndustry[0]['id']
                data_dict = qualificationsInfo(platform_code,export_label, store_type_code, industry_one_code,industry_two_code)
                result_dict['data'] = data_dict
                result_dict['status'] = 0
                result_dict['msg'] = "success"
            except Exception as error:
                # print("获取一级行业大类失败：",error,type(error))
                result_dict['data'] = str(error)
                result_dict['status'] = -1
                result_dict['msg'] = "failed"
            return result_dict
