var system = require("../../system")
var settings = require("../../../config/settings");
const CtlBase = require("../ctl.base");
const moment = require("moment");

class BusistatCtl extends CtlBase {
    constructor() {
        super(CtlBase.getServiceName(BusistatCtl));
        this.departmentSve = system.getObject("service.departmentSve");
        this.excelClient = system.getObject("util.excelClient");
    }

    async suggest(query,qobj,req){
        var name = this.trim(qobj.name);
        if (!name) {
            return system.getResult2([])
        }
        var list = await this.departmentSve.suggestByName(name);
        return system.getResult2(list);
    }

    async departmentList(queryobj, qobj, req) {
        var params = qobj.search;
        try {
            if (params.begin) {
                params.begin = Number(params.begin.replace(new RegExp("-", 'g'), ""));
            }
            if (params.end) {
                params.end = Number(params.end.replace(new RegExp("-", 'g'), ""));
            }

            // this.doTimeCondition(params, ["statBegin", "statEnd"]);
            let page = await this.service.departmentPage(params);
            return system.getResult2(page);
        } catch (e) {
            console.log(e);
            return system.getErrResult2("您的网络不稳, 请稍后重试");
        }
    }

    async departmentExport(pobj, req, res) {
        var params = JSON.parse(pobj.search);
        if (params.begin) {
            params.begin = Number(params.begin.replace(new RegExp("-", 'g'), ""));
        }
        if (params.end) {
            params.end = Number(params.end.replace(new RegExp("-", 'g'), ""));
        }
        try {
            params.currentPage = 1;
            params.pageSize = -1;
            let rows = await this.service.listByCondition(params);
            let csvobj = {
                fileName: "发薪统计-" + moment().format("YYYYMMDD") + ".csv",
                rows: rows,
                opts: {
                    fields: ['user_department_name', 'user_name', 'busi_id', 'busi_name', 'service_tax', 'actual_amt', 'deduct_amt', 'income_tax', 'added_value_tax', 'times'],
                    unwind: ['busistat'],
                    excelStrings: true,
                    unwindBlank: true
                },
                headers: {
                    'user_department_name':"部门名称",
                    'user_name': "业务员",
                    'busi_id': "商户号",
                    'busi_name': "企业名称",
                    'service_tax':"服务费",
                    'actual_amt':"实发金额",
                    'deduct_amt':"扣除金额",
                    'income_tax':"个税",
                    'added_value_tax':"增值税",
                    'times':"发薪次数",
                },
            };
            await this.excelClient.exportCsv(req, res, csvobj);
        } catch (e) {
            console.log(e);
            return system.getErrResult2("您的网络不稳, 请稍后重试");
        }
    }



}

module.exports = BusistatCtl;
