var system = require("../../system")
var settings = require("../../../config/settings");
const CtlBase = require("../ctl.base");

class ChannelCtl extends CtlBase {
  constructor() {
    super(CtlBase.getServiceName(ChannelCtl));
    this.offlinecompanySve = system.getObject("service.offlinecompanySve")
  }

  // 来源
  async originDics(queryobj, obj, req) {
    try {
      let rs = await this.service.originDics(obj);
      return rs;
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }
  async originInfo(queryobj, obj, req) {
    try {
      return await this.service.originInfo(obj);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }
  async originMerchants(queryobj, obj, req) {
    try {
      return await this.service.originMerchants(obj);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

  async offlineMerchants(queryobj, obj, req) {
    try {
      return await this.offlinecompanySve.suggest(obj.name);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

  // 渠道
  async channelSuggest(queryobj, obj, req) {
    try {
      return await this.service.channelSuggest(obj);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }
  async channelDicts(queryobj, obj, req) {
    try {
      return await this.service.channelDicts(obj);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }
  async channelInfo(queryobj, obj, req) {
    try {
      return await this.service.channelInfo(obj);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }
  async channelSave(queryobj, obj, req) {
    try {
      return await this.service.channelSave(obj);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }
  async channelPage(queryobj, obj, req) {
    try {
      return await this.service.channelPage(obj);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

  // 商户
  async merchantInfo(queryobj, obj, req) {
    try {
      return await this.service.merchantInfo(obj);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }
  async merchantSave(queryobj, obj, req) {
    try {
      // if(obj.origin_id == 10001){
      //   var offlinecompany = await this.offlinecompanySve.updateCreate(obj);
      //   if(offlinecompany != -1){
      //     obj.origin_merchant_id = offlinecompany.id;
      //   }
      // }
      return await this.service.merchantSave(obj);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }
  async merchantPage(queryobj, obj, req) {
    try {
      return await this.service.merchantPage(obj);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

}
module.exports = ChannelCtl;
