const system = require("../../system");
const Dao = require("../dao.base");

class BusistatDao extends Dao {
    constructor() {
        super(Dao.getModelName(BusistatDao));
    }

    extraWhere(qobj, qw, qc) {
        qc.raw = true;
        return qw;
    }

    async delByDay(statDay) {
        if (!statDay) {
            return;
        }
        var sql = "DELETE FROM `c_busi_stat` WHERE stat_day = " + Number(statDay);
        return await this.customExecAddOrPutSql(sql);
    }

    async updateDepartmentName(params) {
        let sql = "UPDATE `c_busi_stat` SET user_name = :user_name, user_id=:user_id, user_department_name= :user_department_name WHERE busi_id IN (:busiIds)";
        return await this.customExecAddOrPutSql(sql, {replacements: params});
    }

    async countByCondition(params) {
        let sql = [];
        sql.push("SELECT");
        sql.push("COUNT(DISTINCT busi_id) AS num ");
        sql.push("FROM `c_busi_stat`");
        sql.push("WHERE 1 = 1");

        this.setCondition(sql, params);

        let list = await this.customQuery(sql.join(" "), params);
        if (!list || list.length == 0) {
            return 0;
        }
        return list[0].num || 0;
    }

    async listByCondition(params) {
        params.currentPage = Number(params.currentPage || 1);
        params.pageSize = Number(params.pageSize || 10);
        params.startRow = (params.currentPage - 1) * params.pageSize;

        let sql = [];
        sql.push("SELECT");
        sql.push("id, busi_id, busi_name, user_name, user_department_name, ");
        sql.push("SUM(times) AS times, SUM(amt) AS amt, SUM(actual_amt) AS actual_amt, SUM(deduct_amt) AS deduct_amt,");
        sql.push("SUM(income_tax) AS income_tax, SUM(service_tax) AS service_tax, SUM(added_value_tax)  AS added_value_tax");
        sql.push("FROM `c_busi_stat`");
        sql.push("WHERE 1 = 1");
        this.setCondition(sql, params);

        sql.push("GROUP BY busi_id ");
        sql.push("ORDER BY service_tax DESC ");
        if(params.pageSize && params.pageSize != -1) {
            sql.push(" LIMIT :startRow, :pageSize ");
        }
        return await this.customQuery(sql.join(" "), params);
    }

    async setCondition(sql, params) {
        if (!sql || !params) {
            return;
        }
        if (params.busi_name) {
            params.busi_name_like = `%${params.busi_name}%`;
            sql.push("AND busi_name LIKE :busi_name_like");
        }
        if (params.user_department_name) {
            sql.push("AND user_department_name = :user_department_name");
        }
        if(params.begin) {
            sql.push("AND stat_day >= :begin");
        }
        if(params.end) {
            sql.push("AND stat_day <= :end");
        }
    }

    // async departmentList(params){
    //
    //     var currentPage = Number(params.currentPage || 0);
    //     var pageSize = Number(params.pageSize || 10);
    //     var countsql  = "SELECT COUNT(DISTINCT busi_id) AS num FROM `c_busi_stat` " + "WHERE 1 = 1 "
    //     var listsql = "SELECT busi_name,user_name,user_department_name,SUM(times) AS times,SUM(amt) AS amt,SUM(actual_amt) AS actual_amt,SUM(deduct_amt) AS deduct_amt,SUM(income_tax) AS income_tax,SUM(service_tax) AS service_tax,SUM(added_value_tax)  AS added_value_taxFROM `c_busi_stat` WHERE 1 = 1 \n"
    //
    //     if (params.busi_name) {
    //         countsql = countsql+" AND busi_name LIKE :busi_name";
    //         listsql = listsql+ " AND busi_name LIKE :busi_name"
    //     }
    //     if (params.user_department_name) {
    //         countsql = countsql+" AND user_department_name = :user_department_name"
    //         listsql = listsql+ " AND user_department_name = :user_department_name"
    //     }
    //     if(params.begin) {
    //         countsql = countsql + " AND created_at >= :begin ";
    //         listsql = listsql+ " AND stat_day >= :begin"
    //     }
    //     if(params.end) {
    //         countsql = countsql + " AND created_at <= :end ";
    //         listsql = listsql+ " AND stat_day <= :end"
    //     }
    //     console.log(countsql)
    //     console.log(listsql)
    //     var count = await this.customQuery(countsql, {busi_name:params.busi_name,user_department_name:params.user_department_name,begin:params.begin,end:params.end});
    //
    //     if(count[0].num == 0 ){
    //
    //     }
    //
    //
    // }
}

module.exports = BusistatDao;
