const system = require("../../system");
const Dao = require("../dao.base");

class DepartmentDao extends Dao {
    constructor() {
        super(Dao.getModelName(DepartmentDao));
    }


    async suggest(name) {
        if (!name) {
            return [];
        }
        var sql = "SELECT id, name FROM `p_department` WHERE name LIKE :queryLike AND deleted_at IS NULL ";
        sql = sql + " ORDER BY id ASC ";
        var list = await this.customQuery(sql, {queryLike: "%" + name + "%"});
        return list || [];
    }

}

module.exports = DepartmentDao;
