const system = require("../../system");
const settings = require("../../../config/settings");
const uiconfig = system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
    return db.define("entcontract", {
        name: DataTypes.STRING,
        edocid: DataTypes.STRING, // 合同id
        eflowid: DataTypes.STRING, // 合同流程id
        esignUrl: DataTypes.STRING, // 合同签署链接
        fileurl: DataTypes.STRING,  // 合同文件地址
        eflowstatusname: {
            // 销售状态名称
            type: DataTypes.STRING(20),
            defaultValue: "签署中",
        },
        eflowstatus: {
            type: DataTypes.ENUM,
            values: Object.keys(uiconfig.config.pdict.eflowstatus),
            set: function (val) {
                this.setDataValue("eflowstatus", val);
                this.setDataValue("eflowstatusname", uiconfig.config.pdict.eflowstatus[val]);
            },
            defaultValue: 1,
        },
        entcompany_id: DataTypes.INTEGER,
        enttemplate_id: DataTypes.INTEGER,

        user_id: DataTypes.INTEGER,
        usereaccount_id: DataTypes.INTEGER,
        resultDescription: DataTypes.STRING,

        completed_at: DataTypes.DATE,
        begin_at: DataTypes.DATE,
        end_at: DataTypes.DATE,

    }, {
        paranoid: true, //假的删除
        underscored: true,
        version: true,
        freezeTableName: true,
        //freezeTableName: true,
        // define the table's name
        tableName: 'c_entcontract',
        validate: {},
        indexes: [
            // Create a unique index on email
            //  {
            //    unique: true,
            //    fields: ['email']
            //  },
            //
            //  // Creates a gin index on data with the jsonb_path_ops operator
            //  {
            //    fields: ['data'],
            //    using: 'gin',
            //    operator: 'jsonb_path_ops'
            //  },
            //
            //  // By default index name will be [table]_[fields]
            //  // Creates a multi column partial index
            //  {
            //    name: 'public_by_author',
            //    fields: ['author', 'status'],
            //    where: {
            //      status: 'public'
            //    }
            //  },
            //
            //  // A BTREE index with a ordered field
            //  {
            //    name: 'title_index',
            //    method: 'BTREE',
            //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
            //  }
        ]
    });
}