const ServiceBase = require("../sve.base");

class EtemplatebusiService extends ServiceBase {
    constructor() {
        super(ServiceBase.getDaoName(EtemplatebusiService));
    }

    async getlist(qobj) {
        var sql = "SELECT * FROM c_etemplate_busi WHERE template_type = "+qobj.type+" AND template_id = " + qobj.id;
        var page = await this.customQuery(sql);
        return page;
    }

    async getinfo(qobj) {
        var sql = "SELECT * FROM c_etemplate_busi WHERE template_id = " + qobj.template_id + " AND busi_id = " + qobj.company_id;
        var page = await this.customQuery(sql);
        return page;
    }

    async deleteTetId(qobj) {
        let sql = "DELETE FROM c_etemplate_busi WHERE id = " + qobj.id;
        await this.customExecAddOrPutSql(sql);
        return 1;
    }

    async findOwnerBusiIdMap(template_type) {
        template_type = template_type || 0;
        let sql = [];
        sql.push("SELECT t1.`busi_id`, t3.`owner_id` FROM `c_etemplate_busi` t1");
        sql.push("INNER JOIN `c_etemplate` t2 ON t1.`template_id` = t2.`id` AND template_type = :template_type");
        sql.push("INNER JOIN c_ecompany t3 ON t2.`ecompany_id` = t3.`id`");
        sql.push("WHERE t3.`owner_id` > 0");
        let list = await this.customQuery(sql.join(" "), {template_type: template_type});
        let result = {};
        if (!list || list.length == 0) {
            return result;
        }
        for (let item of list) {
            let busiIds = result[item.owner_id] || [];
            busiIds.push(item.busi_id);
            result[item.owner_id] = busiIds;
        }
        return result;
    }

    async suggest(name, ownerIds) {
        return await this.dao.suggest(name, ownerIds);
    }

    async saveto(etebusi) {
        return await this.create(etebusi);

    }
}

module.exports = EtemplatebusiService;