{
    template: '${tmpl}',
    data: function () {
        var validMethod = (rule, value, callback) => {
            return this.validfileds(rule, value, callback);
        };

        return {
            ecompany: {isEnabled:true},
            editTitle: "新增",
            showEdit: false,
            saveLoading: false,
            ownerList:[],
            ownerMap:[],
            ownerLoading:false,
            owner_id: "",
            search: {
                list: [],
                currentPage: 1,
                pageSize: 20,
                total : 0,
                name:'',
            },
            rules: {
                name : [
                    { required: true, message: '请输入企业名称', trigger: 'blur' },
                    { validator: validMethod, trigger: 'blur' }
                ],
                owner_id: [
                    { required: true, message: '请选择客户归属人员', trigger: 'blur' },
                    { validator: validMethod, trigger: 'blur' }
                ],
                a : [],
            },
        }
    },
    mounted: function () {
        this.resetSearch(true);
    },
    created: function () {},
    methods: {
        getEmptySearch() {
            return {
                list: [],
                currentPage: 1,
                pageSize: 20,
                total : 0,
                name:'',
            }
        },
        resetSearch() {
            this.search = this.getEmptySearch();
            this.getList();
        },
        tableHeaderColor({ row, column, rowIndex, columnIndex }) {
            if (rowIndex === 0) {
                return 'background-color: #F5F5F5;color: #2F2F2F;font-size: 14px;font-weight:400;'
            }
        },
        opSearch() {
            this.search.currentPage = 1;
            this.search.total = 0;
            this.getList();
        },
        getList() {
            var self = this;
            var params = this.getParams();
            this.$root.postReq("/web/ecompanyCtl/signList", {
                search: params
            }).then(function (d) {
                if (d.status == 0) {
                    self.search.list = d.data.rows || [];
                    self.search.total = d.data.count || 0;
                } else {
                }
            });
        },
        getParams() {
            var params = {};
            for(var f in this.search) {
                if(f == "list") {
                    continue;
                }
                params[f] = this.search[f];
            }
            return params;
        },
        onColFormater(row, column, cellValue, index) {
            return cellValue || "---";
        },
        getEcompany(id) {
            var self = this;
            self.$root.postReq("/web/ecompanyCtl/info", {
                id: id,
            }).then(function (d) {
                if (d.status == 0) {
                    if(d.data) {
                        d.data.isEnabled = d.data.isEnabled ? true : false;
                    }
                    self.ecompany = d.data;
                    self.ecompany.owner_id = self.ecompany.owner_id || "";
                    self.owner_id = (d.data.owner || {}).id || "";
                    if(d.data.owner) {
                        self.ownerList = [d.data.owner];
                        self.ownerMap["id_" + d.data.owner.id] = d.data.owner;
                    } else {
                        self.ownerList = null;
                    }
                } else {
                    self.$message.warning(d.msg || `您的网络不稳定, 请稍后重试`);
                }
            });
        },
        toDetail(id) {
        },
        openEdit(id) {
            this.ownerLoading = false;
            this.saveLoading = false;
            this.owner_id = null;
            if(this.$refs.ecompany) {
                this.$refs.ecompany.resetFields();
            }
            if(id) {
                this.getEcompany(id);
                this.editTitle = "修改";
            } else {
                this.ownerList = [];
                this.editTitle = "新增";
                this.ecompany = {isEnabled:true};
            }
            this.showEdit = true;
        },
        handleSizeChange(val) {
            this.search.pageSize = val;
            this.resetSearch();
        },
        handleCurrentChange(val) {
            this.search.currentPage = val;
            this.getList();
        },
        validfileds(rule, value, callback) {
            var self = this;
            if(rule.field == 'name') {
                if(!self.ecompany.name) {
                    return callback(new Error("请输入企业名称"));
                }

                self.$root.postReq("/web/ecompanyCtl/validName", self.ecompany).then(function (d) {
                    if (d.status == 0) {
                        return callback();
                    } else {
                        return callback(new Error(d.msg));
                    }
                });
            } else if(rule.field == 'owner_id') {
                if(!self.ecompany.owner_id) {
                    return callback(new Error("请选择归属人员"));
                } else {
                    return callback();
                }
            } else {
                return callback();
            }
        },

        ownerChange(val) {
            console.log(val, );
            this.ecompany.owner_id = val || 0;
            this.owner = this.ownerMap["id_" + val];
            console.log(this.owner);
        },
        getOwnerList(query) {
            var self = this;
            self.ownerLoading = true;
            self.$root.postReq("/web/userCtl/rolesSuggest", {
                name: query,
                roleCodes: ["zczy", "zcgl", "qdzy", "qdgl", "ptzy", "ptgl", "dkhzy", "dkhgl", "ziying", "tzgl", "tzzy"]
            }).then(function (d) {
                self.ownerLoading = false;
                self.ownerList = d.data || [];
                self.ownerMap = [];

                for (var o of self.ownerList) {
                    self.ownerMap["id_" + o.id] = o;
                }
            });
            setTimeout(() => {
                self.ownerLoading = false; 
            }, 15000);
        },
        saveCompany() {
            var self = this;
            self.saveLoading = true;
            self.$refs.ecompany.validate((valid) => {
                if (valid) {
                    self.$root.postReq("/web/ecompanyCtl/signSave", self.ecompany).then(function (d) {
                        if (d.status == 0) {
                            self.$message.success(`保存成功`);
                            self.showEdit = false;
                            self.getList();
                        } else {
                            self.$alert(d.msg || '保存失败', '提示', {
                                confirmButtonText: '确定',
                                callback: action => {}
                            });
                        }
                        self.saveLoading = false;
                    });
                } else {
                    self.saveLoading = false;
                    return false;
                }
            });
            setTimeout(() => {
                self.saveLoading = false;
            }, 5000);
        },
    },
    vname: "gsb-ecompanyadmin"
}