{
    template: '${tmpl}',
        data: function () {
    var validMethod = (rule, value, callback) => {
        return this.validfileds(rule, value, callback);
    };

    return {
        showDetail: false,
        showEdit: false,
        showAutoEdit: false,
        selname: "",

        submitLoading:false,
        isFirstEdit: true,
        eduTypeList: [],
        search: {
            list: [],
            currentPage: 1,
            pageSize: 20,
            total: 0,
            ecompany_id: '',
            accountName: '',
            accountMobile: '',
            accountIdno: '',
            signBegin: '',
            signEnd: '',
        },
        rules: {
            ecompanyName : [
                { required: true, message: '请输入公司名称', trigger: 'blur' },
                { validator: validMethod, trigger: 'blur' }
            ],
            userName: [
                { required: true, message: '请输入姓名', trigger: 'blur' },
            ],
            mobile: [
                { required: true, message: '请输入手机号', trigger: 'blur' },
                { validator: validMethod, trigger: 'blur' }
            ],
            personsSign: [
                { required: true, message: '请输入身份证', trigger: 'blur' },
            ],
            bankno: [
                { required: true, message: '请输入银行卡', trigger: 'blur' },
            ],
            fileurl: [
                { required: true, message: '请上传签约协议', trigger: 'blur' },
            ],
            fileFourElement: [
                { required: true, message: '请上传签约人员', trigger: 'blur' },
            ],
            a : [],
            etemplateName : [
                { required: true, message: '请输入模板名称', trigger: 'blur' },
                { validator: validMethod, trigger: 'blur' }
            ],
        },

        nameLoading: false,
        nameList: [],
        nameMap:[],

        nameLoading2: false,
        nameList2: [],
        nameMap2:[],
        uploadResult: null,

        autoNameLoading2: false,
        autoNameList2: [],
        autoNameMap2:[],

        aggreement: {},
        autoAggreement: {},
        autoUploadResult: null,
    }
},
    mounted: function () {
        this.resetSearch();
    },
    created: function () {},
    methods: {

        getEmptySearch() {
            return {
                list: [],
                currentPage: 1,
                pageSize: 20,
                total: 0,
                ecompany_id: '',
                accountName: '',
                accountMobile: '',
                accountIdno: '',
                signBegin: '',
                signEnd: '',
            }
        },
        resetSearch() {
            this.search = this.getEmptySearch();
            this.selname = "";
            this.getList();
        },
        tableHeaderColor({row, column, rowIndex, columnIndex}) {
            if (rowIndex === 0) {
                return 'background-color: #F5F5F5;color: #2F2F2F;font-size: 14px;font-weight:400;'
            }
        },
        opSearch() {
            this.getList();
        },
        getList() {
            var self = this;
            this.$root.postReq("/web/entcontractCtl/allList2", {
                search: self.getParams()
            }).then(function (d) {
                if (d.status == 0) {
                    self.search.list = d.data.rows || [];
                    self.search.total = d.data.count || 0;
                } else {}
            });
        },
        getParams() {
            var params = {};
            for (var f in this.search) {
                if (f == "list") {
                    continue;
                }
                params[f] = this.search[f];
            }
            return params;
        },

        exportList() {
            window.open("/web/entcontractCtl/allExport" + this.getExportParams());
        },
        getExportParams() {
            var params = {};
            for(var f in this.search) {
                if(f == "list") {
                    continue;
                }
                params[f] = this.search[f];
            }
            return "?search=" + encodeURIComponent(JSON.stringify(params));
        },
        onColFormater(row, column, cellValue, index) {
            return cellValue || "---";
        },

        handleSizeChange(val) {
            this.search.pageSize = val;
            this.resetSearch();
        },
        handleCurrentChange(val) {
            this.search.currentPage = val;
            this.getList();
        },
        validfileds(rule, value, callback) {
            var self = this;
            if(rule.field == 'name') {
                if(!self.intention.name) {
                    return callback(new Error("请输入客户名称"));
                }

                self.$root.postReq("/web/eintentionCtl/validName", {
                    name: self.intention.name
                }).then(function (d) {
                    if (d.status == 0) {
                        return callback();
                    } else {
                        return callback(new Error(d.msg));
                    }
                });
            } else {
                return callback();
            }

            if(rule.field == "ecompanyName") {
                if(!self.aggreement.ecompany_id) {
                    return callback(new Error("请重新选择公司名称"));
                }
            }
            if(rule.field == "mobile") {
                if(!/^(1)\d{10}$/.text(self.aggreement.mobile)) {
                    return callback(new Error("请输入公司名称"));
                }
            }
        },
        changeStatus() {
            this.curStatus = this.search.applyStatus;
            this.search.currentPage = 1;
            this.search.pageSize = 20;
            this.search.total = 0;
            this.getList();
        },
        openEdit() {
            var self = this;
            self.nameList = [];
            self.aggreement = {};
            self.showEdit = true;
            if(self.isFirstEdit) {
                self.isFirstEdit = false;
            } else {
                self.$refs.aggreement.resetFields();
                self.clearUpload();
            }
        },
        autoOpenEdit() {
            var self = this;
            self.autoAggreement = {};
            self.showAutoEdit = true;
            self.autoClearUpload();
        },
        nameChange(val) {
            console.log(val, "------------------------- ");
            var self = this;
            var item = self.nameMap[val];
            self.search.entcompany_id = (item || {}).id || "";
        },
        nameChange2(val) {
            var self = this;
            var item = self.nameMap2[val];
            self.aggreement.entcompany_id = (item || {}).id || "";

            console.log(val,self.aggreement.entcompany_id, "------------------------- ");
        },
        autoNameChange2(val) {
            var self = this;
            var item = self.autoNameMap2[val];
            self.autoAggreement.etemplate_id = (item || {}).id || "";
            console.log(val,self.autoAggreement.etemplate_id, "---------22222222222---------------- ");
        },
        save() {
            var self = this;

            self.submitLoading = true;
            self.$refs.aggreement.validate((valid) => {
                if (valid) {
                    setTimeout(() => {
                        self.submitLoading = false;
                    }, 5000);
                    self.$root.postReq("/web/entcontractCtl/saveOffline", self.aggreement).then(function (d) {
                        if (d.status == 0) {
                            self.getList();

                            self.$confirm("保存成功，继续录入下一条？", {
                                confirmButtonText: '确定',
                                cancelButtonText: '取消',
                                type: 'success'
                            }).then(() => {
                                self.aggreement = {};
                                self.clearUpload();
                            }).catch(() => {
                                self.showEdit = false;
                            });
                        } else {
                            self.$alert(d.msg || '保存失败', '提示', {
                                confirmButtonText: '确定',
                                callback: action => {}
                            });
                        }
                        self.submitLoading = false;
                    });
                } else {
                    self.submitLoading = false;
                    return false;
                }
            });
        },
        autoSave() {
            var self = this;
            self.submitLoading = true;
            self.$refs.autoAggreement.validate((valid) => {
                self.submitLoading = false;
                if (valid) {
                    var list = self.autoAggreement.autoExcel || [];
                    var d = 3 * list.length;
                    const loading = self.$loading({
                        lock: true,
                        text: '正在签约，请耐心等待，大约需要' + d + '秒后签约完成',
                        spinner: 'el-icon-loading',
                        background: 'rgba(0, 0, 0, 0.7)'
                    });

                    self.$root.postReq("/web/entcontractCtl/autoSaveOffline", self.autoAggreement).then(function (d) {
                        loading.close();
                        if (d.status == 0) {
                            self.getList();
                            self.autoClearUpload();
                            self.showAutoEdit = false;
                            self.$alert('批量录入成功', '提示', {
                                confirmButtonText: '确定',
                                callback: action => {}
                            });
                        } else {
                            self.$alert(d.msg || '保存失败', '提示', {
                                confirmButtonText: '确定',
                                callback: action => {}
                            });
                        }
                    });
                } else {
                    return false;
                }
            });
        },

        getCompanyNames(query) {
            var self = this;
            self.nameLoading = true;
            self.$root.postReq("/web/ecompanyCtl/suggest", {
                name: query
            }).then(function (d) {
                self.nameLoading = false;
                self.nameList = d.data || [];
                self.nameMap = [];
                for(var item of self.nameList) {
                    self.nameMap[item.name] = item;
                }
            });
            setTimeout(() => {
                self.nameLoading = false;
            }, 15000);
        },
        getCompanyNames2(query) {
            var self = this;
            self.nameLoading2 = true;
            self.$root.postReq("/web/ecompanyCtl/suggest", {
                name: query
            }).then(function (d) {
                self.nameLoading2 = false;
                self.nameList2 = d.data || [];
                self.nameMap2 = [];
                for(var item of self.nameList2) {
                    self.nameMap2[item.name] = item;
                }
            });
            setTimeout(() => {
                self.nameLoading2 = false;
            }, 15000);
        },
        getTemplateNames2(query) {
            var self = this;
            self.autoNameLoading2 = true;
            self.$root.postReq("/web/etemplateCtl/getListByName", {
                name: query
            }).then(function (d) {
                self.autoNameLoading2 = false;
                self.autoNameList2 = d.data || [];
                self.autoNameMap2 = [];
                for(var item of self.autoNameList2) {
                    self.autoNameMap2[item.name] = item;
                }
            });
            setTimeout(() => {
                self.autoNameLoading2 = false;
            }, 15000);
        },
        clearUpload() {
            var self = this;
            self.uploadResult = null;
            self.aggreement.fileurl = "";
            if(self.$refs.upload3 && self.$refs.upload3.$refs && self.$refs.upload3.$refs.upload) {
                self.$refs.upload3.$refs.upload.clearFiles();
            }
        },
        autoClearUpload() {
            var self = this;
            self.autoUploadResult = null;
            self.autoAggreement.fileurl = "";
            self.autoAggreement.fileFourElement = "";

            self.$refs.upload3.$refs.upload.clearFiles();
            self.$refs.upload4.$refs.upload.clearFiles();
        },
        uploadsuccess(v) {
            if(!v || !v[0] || !v[0].url) {
                this.$message.warning("上传失败");
                return;
            }
            this.aggreement.fileurl = v[0].url;
        },
        autoUpload(v) {
            if(!v || !v[0] || !v[0].url) {
                this.$message.warning("上传失败");
                return;
            }
            this.autoAggreement.fileurl = v[0].url;
        },
        autoUploadFourElement(v) {
            if(!v || !v[0] || !v[0].url) {
                this.$message.warning("上传失败");
                return;
            }
            this.autoAggreement.fileFourElement = v[0].url;
            this.parseExcel();
        },
        parseExcel() {
            var self = this;
            const loading = this.$loading({
                lock: true,
                text: '正在解析签约人员',
                spinner: 'el-icon-loading',
                background: 'rgba(0, 0, 0, 0.7)'
            });

            self.$root.postReq("/web/usereaccountCtl/parseItems", {
                url: self.autoAggreement.fileFourElement
            }).then(function (d) {
                loading.close();
                if (d.status == 0) {
                    var itemlist = (d.data || {}).list;
                    self.autoAggreement.autoExcel = itemlist;
                    console.log(itemlist,"************22222222222222*****************");
                } else {
                    /* self.autoClearUpload();*/
                    self.$alert(d.msg || "文件解析失败", '提示', {
                        confirmButtonText: '确定',
                        callback: action => {}
                    });
                }
            });
        },
        downloadContractUrl(id) {
            var self = this;
            self.$root.postReq("/web/entcontractCtl/downloadContractUrl", {
                id: id
            }).then(function (d) {
                if (d.status == 0 && d.data) {
                    window.open(d.data);
                } else {
                    self.$message.warning(d.msg || "上传失败");
                }
            });
        },
        toHand(id) {
            var self = this;
            self.$root.postReq("/web/entcontractCtl/yzReSign", {
                id: id
            }).then(function (d) {
                if (d.status == 0 && d.data) {
                    // self.$alert("https://bpohhr.gongsibao.com/bpoent?entid="+id, '提示', {
                    //     confirmButtonText: '确定',
                    //     callback: action => {}
                    // });
                    self.$message.warning(d.msg || "签署成功");
                } else {
                    self.$message.warning(d.msg || "签署失败");
                }
            });
        },
    },
    vname: "gsb-econtractall2"
}
