{
    template: '${tmpl}',
    data: function () {
        var validMethod = (rule, value, callback) => {
            return this.validfileds(rule, value, callback);
        };

        return {
            unsignMsg: "",
            totalActualAmt: 0,
            totalAmt: 0,
            totalServiceTax: 0,
            totalAddedValueTax: 0,
            showDetail:false,
            showEdit: false,
            nameLoading: false,
            submitLoading:false,
            isFirstEdit: true,
            uploadResult: "",
            nameList: [],
            nameMap:[],
            search: {
                list: [],
                currentPage: 1,
                pageSize: 20,
                total : 0,
                ecompanyName: '',
                payBegin: '',
                payEnd: '',
                amtBegin:'',
                amtEnd: '',
            },
            settle:{},
            settleDetail: {},
            itemSearch:{
                list: [],
                currentPage: 1,
                pageSize: 10,
                total : 0,
                esettleoffline_id: 0,
            },
            rules: {
                ecompanyName: [
                    { required: true, message: '请输入客户名称', trigger: 'blur' },
                ],
                sourceType: [
                    { required: true, message: '请选择发薪通道', trigger: 'blur' },
                ],
                pay_complete_time: [
                    { required: true, message: '请选择发薪时间', trigger: 'blur' },
                ],
                service_rate: [
                    { required: true, message: '请输入服务费比率', trigger: 'blur' },
                    { validator: validMethod, trigger: 'blur' }
                ],
                fileurl: [
                    { required: true, message: '请上传发薪明细', trigger: 'blur' },
                    { validator: validMethod, trigger: 'blur' }
                ],
                a : [],
            },
            numberRegex: /^(([1-9]\d*)(\.\d{1,2})?|0\.([1-9]|\d[1-9])|0)$/,

            sourceTypes: [{
                value: 1,
                label: '开封'
              }, {
                value: 2,
                label: '云如薪'
              }
            ],

        }
    },
    mounted: function () {
        this.resetSearch();
    },
    created: function () {
    },
    methods: {
        getEmptySearch() {
            return {
                list: [],
                currentPage: 1,
                pageSize: 20,
                total : 0,
                payBegin: '',
                payEnd: '',
                companyNameLike: '',
                amtBegin:'',
                amtEnd: '',
            }
        },
        resetSearch() {
            this.search = this.getEmptySearch();
            this.getList();
        },
        tableHeaderColor({ row, column, rowIndex, columnIndex }) {
            if (rowIndex === 0) {
                return 'background-color: #F5F5F5;color: #2F2F2F;font-size: 14px;font-weight:400;'
            }
        },
        opSearch() {
            this.getList();
        },
        getList() {
            var self = this;
            this.$root.postReq("/web/esettleofflineCtl/allList", {
                search: this.getParams()
            }).then(function (d) {
                if (d.status == 0) {
                    self.search.list = d.data.rows || [];
                    self.search.total = d.data.count || 0;
                } else {
                }
            });
        },
        getParams() {
            var params = {};
            for(var f in this.search) {
                if(f == "list") {
                    continue;
                }
                params[f] = this.search[f];
            }
            return params;
        },
        onColFormater(row, column, cellValue, index) {
            return cellValue || "0";
        },

        handleSizeChange(val) {
            this.search.pageSize = val;
            this.resetSearch();
        },
        handleCurrentChange(val) {
            this.search.currentPage = val;
            this.getList();
        },
        validfileds(rule, value, callback) {
            var self = this;
            if(rule.field == "service_rate") {
                if(!self.numberRegex.test(value)) {
                    return callback("格式错误，请输入数字，最多保留两位小数");
                }
            }
            if(rule.field == "fileurl") {
                console.log(self.settle.fileurl, self.uploadSuccess, "-------------------");
                if(!self.settle.fileurl || !self.uploadSuccess) {
                    return callback("请重新上传发薪明细");
                }
            }
            return callback();
        },
        changeStatus() {
            this.curStatus = this.search.applyStatus;
            this.search.currentPage = 1;
            this.search.pageSize = 20;
            this.search.total = 0;
            this.getList();
        },
        openDetail(row) {
            this.itemSearch = {
                list: [],
                currentPage: 1,
                pageSize: 10,
                total : 0,
                esettleoffline_id: row.id,
            };
            this.settleDetail = row;
            this.showDetail = true;
            this.getItemList();
        },
        getItemList() {
            var self = this;
            var params = {
                currentPage: self.itemSearch.currentPage,
                pageSize: self.itemSearch.pageSize,
                esettleoffline_id: self.itemSearch.esettleoffline_id
            };
            console.log(params);

            self.$root.postReq("/web/esettleofflineitemCtl/itemList", {
                search: params
            }).then(function (d) {
                if (d.status == 0) {
                    self.itemSearch.list = d.data.rows || [];
                    self.itemSearch.total = d.data.count || 0;
                } else {
                }
            });
        },
        handleSizeChangeItem(val) {
            this.itemSearch.list = [];
            this.itemSearch.currentPage = 1;
            this.itemSearch.pageSize = val;
            this.itemSearch.total = 0;
            this.getItemList();
        },
        handleCurrentChangeItem(val) {
            this.itemSearch.currentPage = val;
            this.getItemList();
        },

        openEdit(id) {
            var self = this;
            self.nameList = [];
            self.clearUpload();
            if(this.isFirstEdit) {
                this.isFirstEdit = false;
            } else {
                this.$refs.settle.resetFields();
            }
            if(id) {
                this.getSettle(id);
            } else {
                self.settle = {};
            }
            self.showEdit = true;
        },

        nameChange(val) {
            this.$refs.settle.validateField('ecompanyName');
            var self = this;
            var item = self.nameMap[val];
            if(item) {
                self.settle.ecompany_id = item.id;
            }
        },
        getCompanyNames(query) {
            var self = this;
            self.nameLoading = true;
            self.$root.postReq("/web/esettleofflineCtl/suggest", {
                name: query
            }).then(function (d) {
                self.nameLoading = false;
                self.nameList = d.data || [];
                self.nameMap = [];
                for(var item of self.nameList) {
                    self.nameMap[item.name] = item;
                }
            });
            setTimeout(() => {
                self.nameLoading = false;
            }, 15000);
        },
        clearUpload() {
            var self = this;
            self.uploadResult = null;
            self.settle.fileurl = "";
            self.uploadSuccess = false;
            if(self.$refs.upload3 && self.$refs.upload3.$refs && self.$refs.upload3.$refs.upload) {
                self.$refs.upload3.$refs.upload.clearFiles();
            }
        },
        uploadsuccess(v) {
            if(!v || !v[0] || !v[0].url) {
                this.$message.warning("上传失败");
                return;
            }

            this.settle.fileurl = v[0].url;
            this.uploadSuccess = false;
            this.parseExcel();
        },
        handleItemList(itemlist) {
            var self = this;
            var totalActualAmt = 0;
            var totalAmt = 0;
            var totalServiceTax = 0;
            var totalAddedValueTax = 0;

            self.uploadSuccess = true;
            if(itemlist) {
                for(var item of itemlist) {
                    totalAmt = totalAmt + Number(item.total_amt || 0);
                    totalActualAmt = totalActualAmt + Number(item.actual_amt || 0);
                    totalServiceTax = totalServiceTax + Number(item.service_tax || 0);
                    totalAddedValueTax = totalAddedValueTax + Number(item.added_value_tax || 0);
                }
            }

            self.settle.amt = self.f2y(totalAmt);
            self.settle.actual_amt = self.f2y(totalActualAmt);
            self.settle.service_tax = self.f2y(totalServiceTax);
            self.settle.added_value_tax = self.f2y(totalAddedValueTax);
            console.log(self.settle, "-----------------------------------");
            self.$refs.settle.validateField('fileurl');
            self.$forceUpdate();
        },
        parseExcel() {
            var self = this;
            const loading = this.$loading({
                lock: true,
                text: '正在努力导入发薪明细',
                spinner: 'el-icon-loading',
                background: 'rgba(0, 0, 0, 0.7)'
            });

            self.$root.postReq("/web/esettleofflineCtl/parseItems", {
                url: self.settle.fileurl,
                pay_complete_time: self.settle.pay_complete_time,
            }).then(function (d) {
                loading.close();
                if (d.status == 0) {
                    var itemlist = (d.data || {}).list;
                    var unsignMsg = (d.data || {}).unsignMsg || "";
                    self.unsignMsg = unsignMsg;
                    if(unsignMsg) {
                        self.$confirm(unsignMsg + '是否继续录入?', '提示', {
                            confirmButtonText: '确定',
                            cancelButtonText: '取消',
                            type: 'warning'
                        }).then(() => {
                            self.handleItemList(itemlist);
                        }).catch(() => {
                            self.settle.amt = 0;
                            self.settle.actual_amt = 0;
                            self.settle.service_tax = 0;
                            self.settle.added_value_tax = 0;
                            self.$forceUpdate();
                            self.clearUpload();
                        });
                    } else {
                        self.handleItemList(itemlist);
                    }
                } else {
                    self.clearUpload();
                    self.$alert(d.msg || "文件解析失败", '提示', {
                        confirmButtonText: '确定',
                        callback: action => {}
                    });
                }
            });
        },
        save() {
            var self = this;
            self.$refs.settle.validate((valid) => {
                if (valid) {
                    const loading = self.$loading({
                        lock: true,
                        text: '正在努力保存',
                        spinner: 'el-icon-loading',
                        background: 'rgba(0, 0, 0, 0.7)'
                    });

                    self.$root.postReq("/web/esettleofflineCtl/save", self.settle).then(function (d) {
                        loading.close();
                        if (d.status == 0) {
                            self.$message.success(`保存成功`);
                            self.showEdit = false;
                            self.getList();
                        } else {
                            self.$alert(d.msg || '保存失败', '提示', {
                                confirmButtonText: '确定',
                                callback: action => {}
                            });
                        }
                    });
                } else {
                    return false;
                }
            });
        },

        getSettle(id) {
            var self = this;
            self.$root.postReq("/web/esettleofflineCtl/findOne", {id: id}).then(function (d) {
                if (d.status == 0) {
                    if(d.data) {
                        d.data.amt = self.f2y(d.data.amt);
                        d.data.actual_amt = self.f2y(d.data.actual_amt);
                        d.data.service_tax = self.f2y(d.data.service_tax);
                        d.data.added_value_tax = self.f2y(d.data.added_value_tax);

                        self.totalActualAmt = d.data.actual_amt;
                    }
                    self.settle = d.data || {};
                    if(self.settle.fileurl) {
                        self.uploadSuccess = true;
                    }
                } else {
                    self.$message.warning(d.msg || "获取结算信息失败");
                }
            });
        },
        f2y(f) {
            return parseFloat(((f || 0) / 100).toFixed(2));
        },
    },
    vname: "gsb-esettlegsblist"
}
