const system = require("../../../system");
var settings = require("../../../../config/settings");
var APIBase = require("../../api.base");

class TradetransferAPI extends APIBase {
  constructor() {
    super();
    this.execlient = system.getObject("util.execClient");
    this.utilsNeedSve = system.getObject("service.utilsSve.utilsNeedSve");
    this.channelApiUrl = settings.channelApiUrl();
    this.centerChannelUrl = settings.centerChannelUrl();
    this.appInfo = {
      aliyuntmtransfer: { appkey: settings.appKey, secret: settings.secret }
    };
  }

  async getToken() {
    var self = this;
    var reqTokenUrl = this.channelApiUrl + "/auth/accessAuth/getToken";
    var reqParam = self.appInfo["aliyuntmtransfer"];
    if (!reqParam.appkey || !reqParam.secret) {
      return system.getResult(null, "reqType类型有误，请求失败");
    }
    var rtn = await this.execlient.execPost(reqParam, reqTokenUrl);
    if (!rtn.stdout) {
      return system.getResult(null, "获取token失败");
    }
    var tokenResult = JSON.parse(rtn.stdout);
    if (tokenResult.status == 0) {
      tokenResult.data.secret = reqParam.secret;
    }
    return tokenResult;
  }

  //订单创建
  async acceptOrder(pobj,qobj,req) {
    if (!pobj.BizId) {
      return {
        "errorCode": "error",
        "errorMsg": "订单号不能为空",
        "module": { "orderNumber": "" },
        "requestId": req.requestId,
        "success": false
      }
    }
    if (!pobj.UserName) {
      return {
        "errorCode": "error",
        "errorMsg": "用户不能为空",
        "module": { "orderNumber": "" },
        "requestId": req.requestId,
        "success": false
      }
    }
    if (!pobj.Mobile) {
      return {
        "errorCode": "error",
        "errorMsg": "用户手机号不能为空",
        "module": { "orderNumber": "" },
        "requestId": req.requestId,
        "success": false
      }
    }
    if (!pobj.Price) {
      return {
        "errorCode": "error",
        "errorMsg": "价格不能为空",
        "module": { "orderNumber": "" },
        "requestId": req.requestId,
        "success": false
      }
    }
    var sobj = {
      "actionProcess": "aliyuntmtransfer",
      "actionType": "aliclient",
      "sign": "2FviZ9PGws8Pt1fBhq0t90mjUvI",
      "isUser": "yes",
      "actionBody": {
        "itemCode": "alitmtt",
        "channelParams": pobj,
        "channelUser": {
          "channelUserId": pobj.Mobile,
          "channelUserName": pobj.UserName,
          "channelUserMoblie": pobj.Mobile,
          "nickname": "",
          "orgName": "",
          "orgPath": ""
        },
        "channelOrder": {
          "channelServiceNo": pobj.BizId,
          "channelOrderNo": "",
          "needNo": pobj.BizId,
          "quantity": 1,
          "totalSum": parseInt(pobj.Price),
          "payTotalSum": parseInt(pobj.Price) * 0.2,
          "payStatus": "bfyfk",
          "payTime": (new Date()).Format("yyyy-MM-dd hh:mm:ss")
        }
      }
    }
    var tokenInfo = await this.getToken();
    var url = this.channelApiUrl + "/action/tradetransfer/createtransfer";
    var rtn = await this.execlient.execPostTK(sobj, url, tokenInfo.data.token);
    //var rtn = await this.execlient.execPostTK(sobj, url,"token");
    return rtn;
  }
  //订单查询
  async queryOrderState(p,obj) {
    var sobj = {
      "actionProcess": "aliyuntmtransfer",
      "actionType": "aliclient",
      "sign": "2FviZ9PGws8Pt1fBhq0t90mjUvI",
      "actionBody": p
    }
    var tokenInfo = await this.getToken();
    console.log(tokenInfo);
    var url = this.channelApiUrl + "/action/tradetransfer/ordersel";
    var rtn = await this.execlient.execPostTK(sobj, url, tokenInfo.data.token);
    console.log(rtn);
    // var rtn = await this.execlient.execPostTK(sobj, url,"token");
    return rtn;
  }

  //订单关闭
  async closeOrder(p,obj) {
    var sobj = {
      "actionProcess": "aliyuntmtransfer",
      "actionType": "aliclient",
      "sign": "2FviZ9PGws8Pt1fBhq0t90mjUvI",
      "actionBody": p
    }
    var tokenInfo = await this.getToken();
    var url = this.channelApiUrl + "/action/tradetransfer/orderclose";
    var rtn = await this.execlient.execPostTK(sobj, url, tokenInfo.data.token);
    // var rtn = await this.execlient.execPostTK(sobj, url,"token");
    return rtn;
  }


  //查询咨询客户列表
  async queryTradeIntentionUserList(p,obj) {
    let sobj = {
      "actionType": "QueryTradeIntentionUserList",
    };
    let tokenInfo = await this.utilsNeedSve.getCenterToken();
    let url = this.centerChannelUrl + "/web/trade/brand/springBoard";
    return await this.execlient.execPostTK(sobj, url, tokenInfo.data.token);
  }

}
module.exports = TradetransferAPI;
