const system = require("../../../system");
const ServiceBase = require("../../sve.base");
var settings = require("../../../../config/settings");
const getRawBody = require('raw-body');
class OplogService extends ServiceBase {
  constructor() {
    super("common", ServiceBase.getDaoName(OplogService));
    //this.appDao=system.getObject("db.appDao");
    this.opLogUrl = settings.apiconfig.opLogUrl();
    this.opLogEsIsAdd = settings.apiconfig.opLogEsIsAdd();
  }
  async error(qobj) {
    this.create(qobj);
  }
  async info(qobj) {
    this.create(qobj);
  }
  async create(qobj) {
    if (!qobj || !qobj.op || qobj.op.indexOf("metaCtl/getUiConfig") >= 0 ||
      qobj.op.indexOf("userCtl/checkLogin") >= 0 ||
      qobj.op.indexOf("getDicConfig") >= 0 ||
      qobj.op.indexOf("getRouteConfig") >= 0 ||
      qobj.op.indexOf("getRsConfig") >= 0) {
      return null;
    }
    var rc = system.getObject("util.execClient");
    var rtn = null;
    try {
      // var myDate = new Date();
      // var tmpTitle=myDate.toLocaleString()+"："+qobj.optitle;
      qobj.optitle = (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "：" + qobj.optitle;
      if (this.opLogEsIsAdd == 1) {
        qobj.content = qobj.content.replace("field list", "字段列表")
        qobj.created_at = (new Date()).getTime();
        //往Es中写入日志
        var addEsData = JSON.stringify(qobj);
        rc.execPost(qobj, this.opLogUrl);
      } else {
        //解决日志大于4000写入的问题
        if (qobj.content.length > 4980) {
          qobj.content = qobj.content.substring(0, 4980);
        }
        this.dao.create(qobj);
      }
    } catch (e) {
      console.log(e.stack, "addLog------error-----------------------*****************");
      qobj.content = e.stack;
      //解决日志大于4000写入的问题
      if (qobj.content.length > 4980) {
        qobj.content = qobj.content.substring(0, 4980);
      }
      this.dao.create(qobj);
    }
  }
  async createDb(qobj) {
    if (!qobj || !qobj.op || qobj.op.indexOf("metaCtl/getUiConfig") >= 0 ||
      qobj.op.indexOf("userCtl/checkLogin") >= 0 ||
      qobj.op.indexOf("getDicConfig") >= 0 ||
      qobj.op.indexOf("getRouteConfig") >= 0 ||
      qobj.op.indexOf("getRsConfig") >= 0) {
      return null;
    }
    try {
      qobj.optitle = (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "：" + qobj.optitle;
      //解决日志大于4000写入的问题
      if (qobj.content.length > 4980) {
        qobj.content = qobj.content.substring(0, 4980);
      }
      this.dao.create(qobj);
    } catch (e) {
      console.log(e.stack, "addLog------error-----------------------*****************");
      qobj.content = e.stack;
      //解决日志大于4000写入的问题
      if (qobj.content.length > 4980) {
        qobj.content = qobj.content.substring(0, 4980);
      }
      this.dao.create(qobj);
    }
  }
  async applicationOctetStream2Json(req) {
    var promiseT = await new Promise((resv, rej) => {
      getRawBody(req, {
        length: req.headers['content-length'],
        encoding: req.charset
      }, function (err, string) {
        if (err) {
          rej(err);
        } else {
          resv(string);
        }
      });
    });
    if (promiseT.length > 0) {
      var step1 = JSON.stringify(promiseT);
      var step2 = JSON.parse(step1);
      var step3 = new Buffer(step2);
      var step4 = step3.toString();
      req.body = JSON.parse(step4);
    }
  }
}
module.exports = OplogService;
