﻿var url = require("url");
var system = require("../../base/system");
// var userSve = system.getObject("service.auth.userSve");
const logCtl = system.getObject("service.common.oplogSve");
const gatewaypushlogSve = system.getObject("service.common.gatewaypushlogSve");
const utilsNeedSve = system.getObject("service.utilsSve.utilsNeedSve");

module.exports = function (app) {

	app.use('/api/ali/esp/intention/submit', async function (req, res) {
		try {
			console.log(req.headers['content-type'])
			if (req.headers['content-type'].indexOf('application/octet-stream') > -1) {
				await logCtl.applicationOctetStream2Json(req);
			}
			var client_ip = system.get_client_ip(req);
			req.body.action_type = "submitNeed";
			var result = await gatewaypushlogSve.submitNeed(req.body, client_ip);
			logCtl.info({
				optitle: (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "回调处理订单结果：，method=" + req.body.trxcode,
				op: "api/ali/esp/intention/submit",
				content: "回调参数：" + JSON.stringify(req.body) + "回调处理订单结果：" + JSON.stringify(result),
				clientIp: client_ip || ""
			});
			res.end(JSON.stringify(result));
			return JSON.stringify(result);
		} catch (error) {
			logCtl.error({
				optitle: (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "记录回调处理结果异常：，method=" + req.body.trxcode,
				op: "/api/ali/esp/intention/submit",
				content: "回调参数：" + JSON.stringify(req.body) + "error：" + error.stack,
				clientIp: client_ip || ""
			});
			return JSON.stringify(result);
		}
	});
	app.use('/api/ali/esp/intention/solution/feedback', async function (req, res) {
		try {
			if (req.headers['content-type'].indexOf('application/octet-stream') > -1) {
				await logCtl.applicationOctetStream2Json(req);
			}
			var client_ip = system.get_client_ip(req);
			req.body.action_type = "receiveFeedback";
			var result = await gatewaypushlogSve.receiveFeedback(req.body, client_ip);
			logCtl.info({
				optitle: (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "回调处理订单结果：，method=" + req.body.trxcode,
				op: "/api/ali/esp/intention/solution/feedback",
				content: "回调参数：" + JSON.stringify(req.body) + "回调处理订单结果：" + JSON.stringify(result),
				clientIp: client_ip || ""
			});
			res.end(JSON.stringify(result));
			return JSON.stringify(result);
		} catch (error) {
			logCtl.error({
				optitle: (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "记录回调处理结果异常：，method=" + req.body.trxcode,
				op: "/api/ali/esp/intention/solution/feedback",
				content: "回调参数：" + JSON.stringify(req.body) + "error：" + error.stack,
				clientIp: client_ip || ""
			});
		}
	});
	app.use('/api/ali/ic/paySuccess', async function (req, res) {
		try {
			if (req.headers['content-type'].indexOf('application/octet-stream') > -1) {
				await logCtl.applicationOctetStream2Json(req);
			}
			var client_ip = system.get_client_ip(req);
			req.body.action_type = "paySuccess";
			var result = await gatewaypushlogSve.paySuccess(req.body, client_ip);
			logCtl.info({
				optitle: (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "回调处理订单结果：，method=" + req.body.action_type,
				op: "/api/ali/ic/paySuccess",
				content: "回调参数：" + JSON.stringify(req.body) + "回调处理订单结果：" + JSON.stringify(result),
				clientIp: client_ip || ""
			});
			res.end(JSON.stringify(result));
			return JSON.stringify(result);
		} catch (error) {
			logCtl.error({
				optitle: (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "记录回调处理结果异常：，method=" + req.body.action_type,
				op: "/api/ali/ic/paySuccess",
				content: "回调参数：" + JSON.stringify(req.body) + "error：" + error.stack,
				clientIp: client_ip || ""
			});
		}
	});
	app.use('/api/ali/ic/close', async function (req, res) {
		try {
			if (req.headers['content-type'].indexOf('application/octet-stream') > -1) {
				await logCtl.applicationOctetStream2Json(req);
			}
			var client_ip = system.get_client_ip(req);
			req.body.action_type = "orderClose";
			var result = await utilsNeedSve.orderClose(req.body, client_ip);
			logCtl.info({
				optitle: (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "回调处理订单结果：，method=" + req.body.trxcode,
				op: "/api/ali/ic/close",
				content: "回调参数：" + JSON.stringify(req.body) + "回调处理订单结果：" + JSON.stringify(result),
				clientIp: client_ip || ""
			});
			res.end(JSON.stringify(result));
			return JSON.stringify(result);
		} catch (error) {
			logCtl.error({
				optitle: (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "记录回调处理结果异常：，method=" + req.body.trxcode,
				op: "/api/ali/ic/close",
				content: "回调参数：" + JSON.stringify(req.body) + "error：" + error.stack,
				clientIp: client_ip || ""
			});
		}
	});
	app.use('/api/ali/esp/intention/close', async function (req, res) {
		try {
			if (req.headers['content-type'].indexOf('application/octet-stream') > -1) {
				await logCtl.applicationOctetStream2Json(req);
			}
			var client_ip = system.get_client_ip(req);
			req.body.action_type = "needClose";
			var result = await gatewaypushlogSve.needClose(req.body, client_ip);
			logCtl.info({
				optitle: (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "回调处理订单结果：，method=" + req.body.trxcode,
				op: "/api/ali/esp/intention/close",
				content: "回调参数：" + JSON.stringify(req.body) + "回调处理订单结果：" + JSON.stringify(result),
				clientIp: client_ip || ""
			});
			res.end(JSON.stringify(result));
			return JSON.stringify(result);
		} catch (error) {
			logCtl.error({
				optitle: (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "记录回调处理结果异常：，method=" + req.body.trxcode,
				op: "/api/ali/esp/intention/close",
				content: "回调参数：" + JSON.stringify(req.body) + "error：" + error.stack,
				clientIp: client_ip || ""
			});
		}
	});


	app.use('/api/ali/tm/consultation/submit', async function (req, res) {
		try {
			console.log(req.headers['content-type'])
			if (req.headers['content-type'].indexOf('application/octet-stream') > -1) {
				await logCtl.applicationOctetStream2Json(req);
			}
			var client_ip = system.get_client_ip(req);
			req.body.action_type = "icpSubmitNeed";
			var result = await gatewaypushlogSve.icpSubmitNeed(req.body, client_ip);
			logCtl.info({
				optitle: (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "回调处理订单结果：，method=" + req.body.trxcode,
				op: "api/ali/tm/consultation/submit",
				content: "回调参数：" + JSON.stringify(req.body) + "回调处理订单结果：" + JSON.stringify(result),
				clientIp: client_ip || ""
			});
			res.end(JSON.stringify(result));
			return JSON.stringify(result);
		} catch (error) {
			logCtl.error({
				optitle: (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "记录回调处理结果异常：，method=" + req.body.trxcode,
				op: "/api/ali/tm/consultation/submit",
				content: "回调参数：" + JSON.stringify(req.body) + "error：" + error.stack,
				clientIp: client_ip || ""
			});
			return JSON.stringify(result);
		}
	});

	app.use('/api/ali/tm/feedback/submit', async function (req, res) {
		try {
			console.log(req.headers['content-type'])
			if (req.headers['content-type'].indexOf('application/octet-stream') > -1) {
				await logCtl.applicationOctetStream2Json(req);
			}
			var client_ip = system.get_client_ip(req);
			req.body.action_type = "icpFeedbackSubmit";
			var result = await gatewaypushlogSve.icpFeedbackSubmit(req.body, client_ip);
			logCtl.info({
				optitle: (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "回调处理订单结果：，method=" + req.body.trxcode,
				op: "api/ali/tm/feedback/submit",
				content: "回调参数：" + JSON.stringify(req.body) + "回调处理订单结果：" + JSON.stringify(result),
				clientIp: client_ip || ""
			});
			res.end(JSON.stringify(result));
			return JSON.stringify(result);
		} catch (error) {
			logCtl.error({
				optitle: (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "记录回调处理结果异常：，method=" + req.body.trxcode,
				op: "/api/ali/tm/feedback/submit",
				content: "回调参数：" + JSON.stringify(req.body) + "error：" + error.stack,
				clientIp: client_ip || ""
			});
			return JSON.stringify(result);
		}
	});

	app.use('/api/ali/tm/status/notify', async function (req, res) {
		try {
			console.log(req.headers['content-type'])
			if (req.headers['content-type'].indexOf('application/octet-stream') > -1) {
				await logCtl.applicationOctetStream2Json(req);
			}
			var client_ip = system.get_client_ip(req);
			req.body.action_type = "icpNotify";
			var result = await gatewaypushlogSve.icpNotify(req.body, client_ip);
			logCtl.info({
				optitle: (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "回调处理订单结果：，method=" + req.body.trxcode,
				op: "api/ali/tm/status/notify",
				content: "回调参数：" + JSON.stringify(req.body) + "回调处理订单结果：" + JSON.stringify(result),
				clientIp: client_ip || ""
			});
			res.end(JSON.stringify(result));
			return JSON.stringify(result);
		} catch (error) {
			logCtl.error({
				optitle: (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "记录回调处理结果异常：，method=" + req.body.trxcode,
				op: "/api/ali/tm/status/notify",
				content: "回调参数：" + JSON.stringify(req.body) + "error：" + error.stack,
				clientIp: client_ip || ""
			});
			return JSON.stringify(result);
		}
	});

  // 2020 0925 lin 新增 阿里文网文 服务商侧提供接口2.1 提交用户需求给服务商
  app.use('/ali/esp/intention/submit', async function (req, res) {
		try {
			console.log(req.headers['content-type'])
			if (req.headers['content-type'].indexOf('application/octet-stream') > -1) {
				await logCtl.applicationOctetStream2Json(req);
			}
			var client_ip = system.get_client_ip(req);
			var result = await gatewaypushlogSve.submitNeedAliEsp(req.body, client_ip);
			logCtl.info({
				optitle: (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "回调处理订单结果：，method=" + req.body.trxcode,
				op: "/ali/esp/intention/submit",
				content: "回调参数：" + JSON.stringify(req.body) + "回调处理订单结果：" + JSON.stringify(result),
				clientIp: client_ip || ""
			});
			res.end(JSON.stringify(result));
			return JSON.stringify(result);
		} catch (error) {
			logCtl.error({
				optitle: (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "记录回调处理结果异常：，method=" + req.body.trxcode,
				op: "/ali/esp/intention/submit",
				content: "回调参数：" + JSON.stringify(req.body) + "error：" + error.stack,
				clientIp: client_ip || ""
			});
			return JSON.stringify(result);
		}
	});


  // 2020 0926 lin 新增 阿里文网文 服务商侧提供接口2.2 关闭需求通知服务商
  app.use('/ali/esp/intention/close', async function (req, res) {
		try {
			console.log(req.headers['content-type'])
			if (req.headers['content-type'].indexOf('application/octet-stream') > -1) {
				await logCtl.applicationOctetStream2Json(req);
			}
			var client_ip = system.get_client_ip(req);
			var result = await gatewaypushlogSve.needCloseAliEsp(req.body, client_ip);
			logCtl.info({
				optitle: (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "回调处理订单结果：，method=" + req.body.trxcode,
				op: "/ali/esp/intention/close",
				content: "回调参数：" + JSON.stringify(req.body) + "回调处理订单结果：" + JSON.stringify(result),
				clientIp: client_ip || ""
			});
			res.end(JSON.stringify(result));
			return JSON.stringify(result);
		} catch (error) {
			logCtl.error({
				optitle: (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "记录回调处理结果异常：，method=" + req.body.trxcode,
				op: "/ali/esp/intention/close",
				content: "回调参数：" + JSON.stringify(req.body) + "error：" + error.stack,
				clientIp: client_ip || ""
			});
			return JSON.stringify(result);
		}
  });

  // 2020 0927 lin 新增 阿里文网文 服务商侧提供接口2.3 服务单通知服务商
  app.use('/api/ali/esp/produce/notice', async function (req, res) {
		try {
			console.log(req.headers['content-type'])
			if (req.headers['content-type'].indexOf('application/octet-stream') > -1) {
				await logCtl.applicationOctetStream2Json(req);
			}
			var client_ip = system.get_client_ip(req);
			var result = await gatewaypushlogSve.produceNoticeAliEsp(req.body, client_ip);
			logCtl.info({
				optitle: (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "回调处理订单结果：，method=" + req.body.trxcode,
				op: "/api/ali/esp/produce/notice",
				content: "回调参数：" + JSON.stringify(req.body) + "回调处理订单结果：" + JSON.stringify(result),
				clientIp: client_ip || ""
			});
			res.end(JSON.stringify(result));
			return JSON.stringify(result);
		} catch (error) {
			logCtl.error({
				optitle: (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "记录回调处理结果异常：，method=" + req.body.trxcode,
				op: "/api/ali/esp/produce/notice",
				content: "回调参数：" + JSON.stringify(req.body) + "error：" + error.stack,
				clientIp: client_ip || ""
			});
			return JSON.stringify(result);
		}
  });

  // 2020 0928 lin 新增 阿里文网文 服务商侧提供接口2.4 ⽤户⽅案反馈通知服务商
  app.use('/api/ali/esp/intention/solution/feedback', async function (req, res) {
		try {
			console.log(req.headers['content-type'])
			if (req.headers['content-type'].indexOf('application/octet-stream') > -1) {
				await logCtl.applicationOctetStream2Json(req);
			}
			var client_ip = system.get_client_ip(req);
			var result = await gatewaypushlogSve.soulutionFeebackAliEsp(req.body, client_ip);
			logCtl.info({
				optitle: (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "回调处理订单结果：，method=" + req.body.trxcode,
				op: "/esp/intention/solution/feedback",
				content: "回调参数：" + JSON.stringify(req.body) + "回调处理订单结果：" + JSON.stringify(result),
				clientIp: client_ip || ""
			});
			res.end(JSON.stringify(result));
			return JSON.stringify(result);
		} catch (error) {
			logCtl.error({
				optitle: (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "记录回调处理结果异常：，method=" + req.body.trxcode,
				op: "/esp/intention/solution/feedback",
				content: "回调参数：" + JSON.stringify(req.body) + "error：" + error.stack,
				clientIp: client_ip || ""
			});
			return JSON.stringify(result);
		}
  });
  

	app.get('/api/:gname/:qname/:method', function (req, res) {
		var classPath = req.params["qname"];
		var methodName = req.params["method"];
		var gname = req.params["gname"];

		classPath = gname + "." + classPath;
		var tClientIp = system.get_client_ip(req);
		req.clientIp = tClientIp;
		req.uagent = req.headers["user-agent"];
		req.classname = classPath;

		var params = [];
		params.push(gname);
		params.push(methodName);
		params.push(req.body);
		params.push(req.query);
		params.push(req);
		var p = null;
		var invokeObj = system.getObject("api." + classPath);
		if (invokeObj["doexec"]) {
			p = invokeObj["doexec"].apply(invokeObj, params);
		}
		p.then(r => {
			res.end(JSON.stringify(r));
		});
	});
	app.post('/api/:gname/:qname/:method', function (req, res) {
		var classPath = req.params["qname"];
		var methodName = req.params["method"];
		var gname = req.params["gname"];
		var params = [];
		classPath = gname + "." + classPath;
		var tClientIp = system.get_client_ip(req);

		req.clientIp = tClientIp;
		req.uagent = req.headers["user-agent"];
		req.classname = classPath;

		params.push(gname);
		params.push(methodName);
		params.push(req.query);
		params.push(req.body);
		params.push(req);
		var p = null;
		var invokeObj = system.getObject("api." + classPath);
		if (invokeObj["doexec"]) {
			p = invokeObj["doexec"].apply(invokeObj, params);
		}
		p.then(r => {
			res.end(JSON.stringify(r));
		});
	});
	app.post('/:gname/:qname/:method', function (req, res) {
		var classPath = req.params["qname"];
		var methodName = req.params["method"];
		var gname = req.params["gname"];
		var params = [];
		classPath = gname + "." + classPath;
		var tClientIp = system.get_client_ip(req);

		req.clientIp = tClientIp;
		req.uagent = req.headers["user-agent"];
		req.classname = classPath;

		params.push(gname);
		params.push(methodName);
		params.push(req.body);
		params.push(req.query);
		params.push(req);
		var p = null;
		var invokeObj = system.getObject("api." + classPath);
		if (invokeObj["doexec"]) {
			p = invokeObj["doexec"].apply(invokeObj, params);
		}
		p.then(r => {
			res.end(JSON.stringify(r));
		});
	});
};
