var APIBase = require("../../api.base");
var system = require("../../../system");
class DiagnosisNeedBusAPI extends APIBase {
  constructor () {
    super();
    this.dnbSve = system.getObject("service.dbneed.diagnosisneedbusSve");
    this.needSve = system.getObject('service.dbneed.opneedinfoSve')
  }

  async springBoard (pobj, qobj, req) {
    // if (!pobj.actionType) {
    //   return system.getResult(null, "actionType参数不能为空");
    // }
    // if (pobj.actionType == 'TODO: 认证结果 / 方案') {
    //   if (!pobj.userInfo) {
    //     return system.getResult(system.noLogin, "user no login!");
    //   }
    //   if (!pobj.appInfo) {
    //     return system.getResult(system.noLogin, "app is null!");
    //   }
    // }
    var result = await this.opActionProcess(pobj, pobj.actionType, req);
    return result;
  }
  async opActionProcess (pobj, action_type, req) {
    var opResult = null;
    switch (action_type) {
      case "getList": // 获取列表 
        opResult = await this.dnbSve.getList(pobj, pobj.actionBody, req);
        break;
      case "getDetail": // 获取详情
        opResult = await this.dnbSve.getDetail(pobj, pobj.actionBody.id);
        break;
      case "doEAV": // 审核
        opResult = await this.dnbSve.doEAV(pobj, pobj.actionBody, req);
        break;
      case 'getNeedList': // 需求列表
        opResult = await this.needSve.opNeedListBak(pobj, pobj.actionBody, req);
        break
      case 'getNeedDetail': // 需求详情
        opResult = await this.needSve.getItemByNeedNo(pobj);
        break
      case 'addCase': // 新建方案
        opResult = await this.dnbSve.addCase(pobj, pobj.actionBody)
        break
      default:
        opResult = system.getResult(null, "actionType参数错误");
        break
    }
    return opResult;
  }

}
module.exports = DiagnosisNeedBusAPI;