const Dao = require("../../dao.base");
class diagnosisDao extends Dao {
  constructor () {
    super(Dao.getModelName(diagnosisDao));
  }
  async findAndCountAll (query) {
    return await this.model.findAndCountAll(query)
  }

  async update (param, id) {
    return await this.model.update(param, { where: { id } })
  }

  async findOneOrderByCreateAt (uid) {
    return await this.model.findOne({
      where: {
        channel_user_Id: uid
      },
      attributes: [
        "diagnosis_no",
        "corporate_name",
        "publish_mobile",
        "publish_name",
        "diagnosis_result",
        "whether_company",
        "qualifications_pic",
        "brand_pic",
        "industry_pic"],
      order: [
        ["updated_at", "desc"]
      ],
      raw: true
    });
  }

  async findOneByDiagnosisNo (diagnosisNo) {
    return await this.model.findOne({
      where: {
        diagnosis_no: diagnosisNo
      },
      attributes: [
        "diagnosis_no",
        "corporate_name",
        "diagnosis_type_name",
        "publish_mobile",
        "main_class",
        "corporate_type_name",
        "whether_company",
        "created_at",
        "qualifications_pic",
        "brand_pic",
        "industry_pic",
        "diagnosis_result",
        "diagnosis_result_name",
        "diagnosis_result_data"],
      raw: true
    });
  }
}
module.exports = diagnosisDao;