const system = require("../../../system");
const settings = require("../../../../config/settings");
const uiconfig = system.getUiConfig2(settings.appKey);
module.exports = (db, DataTypes) => {
  return db.define("policyneed", {                                                                                                                                                                      
    uapp_id              :DataTypes.INTEGER,//     
    contacts             :DataTypes.STRING(64),// 联系人       
    company           :DataTypes.STRING(255),// 公司名称    
    industry           :DataTypes.STRING(100),// 行业名称    
    region           :DataTypes.STRING(100),// 地区    
    mobile           :DataTypes.STRING(100),// 联系电话    
    policy_id           :DataTypes.INTEGER,// 政策id      
    policySnapshot           :DataTypes.TEXT('long'),// 政策快照   
    applyDate              :DataTypes.DATE,//  申请日期                                                                                                                                                                                                                
    opNotes               :DataTypes.TEXT('long'),//  备注     
    createUserId           :DataTypes.INTEGER,// 创建用户id    
    popularizeUserId           :DataTypes.INTEGER,// 推广人id，即业务员id      
    popularizeUserCode           :DataTypes.STRING(64),// 推广人帐号     
    customerIntentionName: DataTypes.STRING(100),//   客户意向                                                                                                                             
    customerIntention      :{// "customer_intention":{"dgj":"待跟进","yyx":"有意向","wyx":"无意向"},
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.customer_intention),
      set: function (val) {
        this.setDataValue("customerIntention", val);
        this.setDataValue("customerIntentionName", uiconfig.config.pdict.customer_intention[val]);
      }
    },  
    isPushAlready: {//是否已推送
      type: DataTypes.BOOLEAN,
      defaultValue: false
    }, 
  }, {
      paranoid: false,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      timestamps: true,
      updatedAt: false,
      //freezeTableName: true,
      // define the table's name
      tableName: 'b_policy_need',
      validate: {

      },
      indexes: [      
      ]
    });
}
