const system = require("../../../system");
const ServiceBase = require("../../sve.base");
class UsuallyContactsService extends ServiceBase {
  constructor() {
    super("dbcorder", ServiceBase.getDaoName(UsuallyContactsService));
  }

  //添加常用联系人、申请人
  async addContacts(pobj,actionBody){
    if (!actionBody.channel_user_id) {
      return system.getResultFail(-1, "渠道用户id不能为空");
    }
    if(!actionBody.contacts){
      return system.getResultFail(-1,'用户信息不能为空');
    }
    if(!actionBody.type){
      return system.getResultFail(-1,'类型不能为空');
    }
    let params = {
      channel_user_id:actionBody.channel_user_id,
      uapp_id:pobj.appInfo.uapp_id,
      type:actionBody.type,
      contact_name:actionBody.contacts.contacts || actionBody.contacts.name
    }
    let item = await this.findOne(params);
    if(item){
      return system.getResultFail(-1,'联系人已存在，请勿重复添加')
    }
    let contactsInfo = {
      uapp_id: pobj.appInfo.uapp_id,
      channel_user_id:actionBody.channel_user_id,
      contact_name:actionBody.contacts.name || actionBody.contacts.contacts,
      contacts_content:actionBody.contacts,
      type:actionBody.type
    }
    let result = await this.create(contactsInfo);
    return system.getResultSuccess({id:result.id});
  }

  //删除常用联系人、申请人
  async delContacts(pobj,actionBody){
    let params = {
      id:actionBody.id,
      uapp_id:pobj.appInfo.uapp_id
    }
    await this.delete(params);
    return system.getResultSuccess();
  }

  //修改常用联系人、申请人
  async updateContacts(pobj,actionBody){
    if(!actionBody.id){
      return system.getResultFail(-1,'id 不能为空');
    }
    if(!actionBody.channel_user_id){
      return system.getResultFail(-1,'id 不能为空');
    }
    if(Object.keys(actionBody.contacts).length<0){
      return system.getResultFail(-1,'信息不能为空');
    }
    let params = {
      channel_user_id:actionBody.channel_user_id,
      uapp_id:pobj.appInfo.uapp_id,
      type:actionBody.type,
      contact_name:actionBody.contact_name
    }
    let item = await this.findOne(params);
    if(item){
      return system.getResultFail(-1,'联系人已存在，请勿重复添加')
    }
    let obj = {
      id:actionBody.id,
      uapp_id:pobj.appInfo.uapp_id,
      channel_user_id:actionBody.channel_user_id
    }
    let setParams = {
      contact_name :actionBody.contacts.contacts || actionBody.contacts.name,
      contacts_content:actionBody.contacts
    }
    let result = await this.updateByWhere(setParams, {where:obj});
    return system.getResultSuccess();
  }

  //查询常用联系人、申请人
  async getContacts(pobj,actionBody){
    let sql = `select id,channel_user_id,contact_name,contacts_content,type from c_usually_contacts where uapp_id = :uapp_id and channel_user_id = :channel_user_id and type = :type`;
    if(!actionBody.type){
      return system.getResultFail(-1,'type 不能为空')
    }
    if(!actionBody.channel_user_id){
      return system.getResultFail(-1,'type 不能为空')
    }
    let paramsWhere = {
      uapp_id : pobj.appInfo.uapp_id,
      channel_user_id: actionBody.channel_user_id,
      type:actionBody.type
    }
    if(actionBody.contact_name){
      sql += ` and contact_name = :contact_name`;
      paramsWhere['contact_name'] = actionBody.contact_name;
    }
    sql += ` and deleted_at is null`
    let result = await this.customQuery(sql,paramsWhere);
    return system.getResult(result);
  }
}
module.exports = UsuallyContactsService;
