var system = require("../../../system")
const CtlBase = require("../../ctlms.base");
class MerchantCtl extends CtlBase {
  constructor() {
    super();
    this.merchantSve = system.getObject("service.saas.merchantSve");
  }

  async dics(params, pobj2, req) {
    try {
      return await this.merchantSve.dics(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  // 开票类型字典获取
  async feeTypeDic(params, pobj2, req) {
    try {
      params.forceUpdate = true;
      let feeType = await this.merchantSve.getFeeTypeWithCache(params);
      let dic = [{"type": "00", "name": "注册订单付款"}, {"type": "10", "name": "转账交易付款10（仅供测试）"}, {"type": "20", "name": "转账交易付款20（仅供测试）"}];
      // let dic = [{"type": "00", "name": "注册订单付款"}, {"type": feeType, "name": "转账交易付款"}];
      return system.getResultSuccess(dic);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async info(params, pobj2, req) {
    try {
      return await this.merchantSve.info(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async page(params, pobj2, req) {
    try {
      this.doTimeCondition(params, ["createBegin", "createEnd"]);
      return await this.merchantSve.page(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async signPage(params, pobj2, req) {
    try {
      params.is_sign = 1;
      this.doTimeCondition(params, ["createBegin", "createEnd"]);
      return await this.merchantSve.page(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async save(params, pobj2, req) {
    try {
      return await this.merchantSve.save(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async sign(params, pobj2, req) {
    try {
      params.bm_reg_price = system.y2f(params.bm_reg_price || 0);
      params.invoice_service_rate = system.y2f(params.invoice_service_rate || 0);
      params.trans_service_rate = system.y2f(params.trans_service_rate || 0);
      return await this.merchantSve.sign(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async signInfo(params, pobj2, req) {
    try {
      return await this.merchantSve.signInfo(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }
  async title(params, pobj2, req) {
    try {
      return await this.merchantSve.title(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }
  async addr(params, pobj2, req) {
    try {
      return await this.merchantSve.addr(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }
  async saveAddr(params, pobj2, req) {
    try {
      if(!params.id) {
        return system.getResult(null, "编辑失败，请联系平台增加开票信息");
      }
      if(!params.mail_to) {
        return system.getResult(null, `联系人不能为空`);
      }
      if(!params.mail_mobile) {
        return system.getResult(null, `联系电话不能为空`);
      }
      if(!params.mail_addr) {
        return system.getResult(null, `邮寄地址不能为空`);
      }
      return await this.merchantSve.saveAddr(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

}
module.exports = MerchantCtl;
