var system = require("../../../system")
const CtlBase = require("../../ctlms.base");
class ChannelCtl extends CtlBase {
  constructor() {
    super();
    this.orderSve = system.getObject("service.saas.orderSve");
    this.merchantSve = system.getObject("service.saas.merchantSve");
  }

  async microAdd(params, pobj2, req) {
    try {
      return await this.orderSve.microAdd(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async info(params, pobj2, req) {
    try {
      return await this.orderSve.info(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async page(params, pobj2, req) {
    try {
      return await this.orderSve.page(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async checkPay(params, pobj2, req) {
    try {
      if(!params.ids || params.ids.length == 0) {
        return system.getResult(null, "请至少选择一笔订单");
      }

      let omap = await this.orderSve.mapByIds({ids: params.ids, attrs: "id, pay_status, price"});
      let totalPrice = 0;
      let totalNum = 0;
      for(let id of params.ids) {
        let obj = omap[id];
        if(!obj || obj.pay_status !== "10") {
          return system.getResult(null , "选择的订单中存在已支付的订单");
        }

        totalPrice = totalPrice + Number(obj.price);
      }

      totalNum = params.ids.length;
      totalPrice = system.f2y(totalPrice);
      let info = await this.merchantSve.signInfo({id: params.saas_merchant_id}) || {};
      info = info.data || {};
      let main = info.main || {};
      let result = {
        totalNum : totalNum,
        totalPrice : totalPrice,
        account_name: main.bank_account,
        account_bank_name: main.bank_name,
        account_bank_no: main.bank_no,
      }
      // 获取商户信息
      return system.getResult(result);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async offlinePay(params, pobj2, req) {
    try {
      if(!params.ids || params.ids.length == 0) {
        return system.getResult(null, "请至少选择一笔订单");
      }
      if (!this.trim(params.pay_voucher_img)) {
        return system.getResult(null, "请上传付款凭证");
      }
      if (!this.trim(params.merchant_deliver_man)) {
        return system.getResult(null, "请填写交付联系人");
      }
      if (!this.trim(params.merchant_deliver_mobile)) {
        return system.getResult(null, "请填写联系人电话");
      }
      if (!this.trim(params.merchant_deliver_addr)) {
        return system.getResult(null, "请填写邮寄地址");
      }
      return await this.orderSve.offlinePay(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

}
module.exports = ChannelCtl;