const system = require("../../../system");
const ServiceBase = require("../../svems.base")
const settings = require("../../../../config/settings")
class InvoiceService extends ServiceBase {
    constructor() {
        super();
        this.tradeSve = system.getObject("service.trade.tradeSve");
    }

    async merchantinvoicePage(params) {
        var rs = await this.callms("invoice", "merchantinvoicePage", params);
        if (rs && rs.data && rs.data.rows) {
            this.transOrderField(rs.data.rows);
        }
        return rs;
    }

    async merchantinvoiceapplyPage(params) {
        var rs = await this.callms("invoice", "merchantinvoiceapplyPage", params);
        if (rs && rs.data && rs.data.rows) {
            this.transOrderField(rs.data.rows);
        }
        return rs;
    }

    async applySave(params) {
        var rs = await this.callms("invoice", "invoiceapplySave", params);
        if (rs && rs.data && rs.data.rows) {
            this.transOrderField(rs.data.rows);
        }
        return rs;
    }

    async applyBulkSave(params) {
        let rs = await this.callms("invoice", "invoiceapplyBulkSave", params);
        return rs;
    }

    transOrderField(rows) {
        if (!rows || rows.length == 0) {
            return;
        }

        for (let row of rows) {
            row.price = system.f2y(row.price);
            row.invoice_amount = system.f2y(row.invoice_amount);
        }
    }

    /**
     * 发票详情
     * @param {*} params 
     */
    async invoiceOrder(params) {
        try {
            let saasInvoiceApply = await this.callms("invoice", "saasInvoiceInfo", params);

            if (saasInvoiceApply.status != 0 || !saasInvoiceApply.data) {
                return system.getResult(null, `系统错误`);
            }
            saasInvoiceApply = saasInvoiceApply.data;
            let tradOrder = [];
            if (saasInvoiceApply.fee_type == "00") { //个体户注册订单
                let invoiceOrderRes = await this.callms("order", "saasOrderPage", { saas_invoice_id: this.trim(params.id) ,currentPage:1,pageSize:99999});
                if (invoiceOrderRes.status == 0) {
                    tradOrder = invoiceOrderRes.data.rows || [];
                }
            } else { //查询流水
                let tradOrderRes = await this.tradeSve.invoiceTrade({
                    id: saasInvoiceApply.id,
                    order_type: saasInvoiceApply.fee_type
                });
                if (tradOrderRes.status == 0) {
                    tradOrder = tradOrderRes.data;
                };
                saasInvoiceApply.service_tax=system.f2y(saasInvoiceApply.service_tax);
            }
            saasInvoiceApply.tradOrder = tradOrder;
            return system.getResult(saasInvoiceApply);
        } catch (error) {
            console.log(error);
            return system.getResult(null, `系统错误`);
        }
    }

    async byIds(params) {
        let rs = await this.callms("order", "itemByIds", params);
        return rs;
    }

    async updateInvoice(params) {
        let rs = await this.callms("order", "updateItemInvoice", params);
        return rs;
    }

    /**
     *
     * @param params
     * @returns {Promise<void>}
     */
    async invoiceBycreditCode(params){
        return await this.callms("invoice", "invoiceBycreditCode", params);
    }
}
module.exports = InvoiceService;