const system = require("../../../system");
const ServiceBase = require("../../svems.base")

class MerchantAppletuserService extends ServiceBase {
  constructor() {
    super();
    this.redisClient = system.getObject("util.redisClient");
  }

  async login(params) {
    try {
      return await this.callms("uc", "appletLogin", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async getLoginUser(params) {
    let key = "applet_login_" + params.merchant_id +"_" + params.openid;
    try {
      let user = await this.redisClient.get(key);
      if(!user) {
        let appletUserInfo = await this.callms("uc", "appletUserInfo", params) || {};
        user = appletUserInfo.data;
        if(user) {
          await this.redisClient.setWithEx(key, JSON.stringify(user), 60 * 33);
        }
      } else {
        user = JSON.parse(user);
      }
      return user;
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

}

module.exports = MerchantAppletuserService;