var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class OpProductAPI extends APIBase {
    constructor() {
        super();
        this.productSve = system.getObject("service.dbproduct.productSve");
    }
    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionProcess) {
            return system.getResult(null, "actionProcess参数不能为空");
        }
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = null;
        switch (pobj.actionProcess) {
            case "jd"://京东
                result = await this.opActionProcess(pobj.actionProcess, pobj.actionType, pobj.actionBody, pobj, req);
                break;
            case "1688"://1688
                result = await this.opActionProcess(pobj.actionProcess, pobj.actionType, pobj.actionBody, pobj, req);
                break;
            case "gsbhome"://gsb_homepage
                result = await this.opActionProcess(pobj.actionProcess, pobj.actionType, pobj.actionBody, pobj, req);
                break;
            default:
                result = system.getResult(null, "actionProcess参数错误");
                break;
        }
        return result;
    }
    async opActionProcess(action_process, action_type, action_body, pobj, req) {
        // action_body.app = req.app;
        // action_body.user = req.user;
        var opResult = null;
        switch (action_type) {
            case "findByTypeCode"://通过产品类别编码获取产品列表
                action_body["app"]=pobj.app;
                opResult = await this.productSve.findByTypeCode(action_body);
                break;
            case "findByTypeOneCode"://通过产品大类编码获取产品列表
                action_body["app"]=pobj.app;
                opResult = await this.productSve.findByTypeOneCode(action_body);
                break;
            case "getProductDetailByCode"://获取产品详情
                opResult = await this.productSve.getProductDetailByCode(action_body.itemCode,pobj.uapp_id);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }


}
module.exports = OpProductAPI;