var APIBase = require("../../api.base");
var system = require("../../../system");
class AccessAuthAPI extends APIBase {
    constructor() {
        super();
        this.opPlatformUtils = system.getObject("util.businessManager.opPlatformUtils");
    }
    async getTokenByHosts(pobj, qobj, req) {
        var app_hosts = pobj.app_hosts || "";
        if (!app_hosts) {
            return system.getResult(null, "app_hosts can not be empty ！");
        }
        var result = await this.opPlatformUtils.getReqTokenByHosts(app_hosts);
        return result;
    }
    async loginUserByChannelUserId(pobj, qobj, req) {
        if (!pobj.channelUserId) {
            return system.getResult(null, "pobj.channelUserId can not be empty ！");
        }
        var result = await this.opPlatformUtils.getReqUserPinByChannelUserId(pobj);
        return result;
    }
    /**
  * 开放平台回调处理
  * @param {*} req 
  */
    async authByCode(pobj, qobj, req) {
        return await this.opPlatformUtils.authByCode(qobj.code);
    }
}
module.exports = AccessAuthAPI;