const CacheBase = require("../cache.base");
const system = require("../../system");
const settings = require("../../../config/settings");
class AppUserPinByChannelUserIdCache extends CacheBase {
  constructor() {
    super();
    this.opPlatformUtils = system.getObject("util.businessManager.opPlatformUtils");
    this.restClient = system.getObject("util.restClient");
    this.appuserDao = system.getObject("db.dbapp.appuserDao");
  }
  desc() {
    return "应用中缓存访问token";
  }
  prefix() {
    return settings.cacheprefix + "_userPin:";
  }
  async buildCacheVal(cachekey, inputkey, val, ex, ...items) {
    var actionBody = val;
    var uUserName = actionBody.channelUserId + "$" + actionBody.appInfo.uapp_key;//uUserName
    var createUserPwd = inputkey;//(格式：actionBody.appInfo.uapp_key+”_“+actionBody.channelUserId)
    var channelUserMoblie = actionBody.channelUserMoblie || "15010888888";
    var userInfo = await this.appuserDao.getItemByChannelUserId(actionBody.channelUserId, actionBody.appInfo.uapp_id);
    if (userInfo) {
      if (userInfo.is_enabled != 1) {
        return system.getResult(null, "user to item is Disable ！");
      }
      return system.getResultSuccess(userInfo);
    }
    var uUserInfo = await this.opPlatformUtils.createUserInfo(actionBody.channelUserId, channelUserMoblie,
      createUserPwd, actionBody.appInfo.uapp_key, actionBody.appInfo.uapp_secret);
    if (uUserInfo.status != 2000 && uUserInfo.status != 0) {
      return uUserInfo;
    }//已经存在此用户 或 注册失败
    if (uUserInfo.status == 0) {
      var params = {
        uapp_id: actionBody.appInfo.uapp_id,
        channel_userid: actionBody.channelUserId,
        channel_username: actionBody.channelUserName || actionBody.channelUserId,
        channel_nickname: actionBody.nickName || "",
        mobile: channelUserMoblie,
        org_name: actionBody.orgName || "",
        org_path: actionBody.orgPath || "",
        is_enabled: 1,
        email: actionBody.email || "",
        last_login_time: new Date()
      };
      userInfo = await this.appuserDao.create(params);
    }
    else {
      return uUserInfo;
    }
    return system.getResultSuccess(userInfo);
    var app_hosts = val;
    if (!app_hosts) {
      return system.getResult(null, "app_hosts can not be empty");
    }
    var acckapp = await this.restClient.execPost(val, settings.centerAppUrl() + "auth/accessAuth/loginUserByChannelUserId");
    var result = acckapp.stdout;
    console.log(acckapp.stdout, "AppTokenByHostsCache............. acckapp.stdout..........");
    if (result) {
      var tmp = JSON.parse(result);
      return tmp;
    }
    return system.getResult(null, "data is empty");
  }
}
module.exports = AppUserPinByChannelUserIdCache;
