const system = require("../../../system");
const Dao = require("../../dao.base");
class AppDao extends Dao {
  constructor() {
    super(Dao.getModelName(AppDao));
  }
  async getItemByHosts(app_hosts) {
    return this.model.findOne({
      where: {
        app_hosts: app_hosts
      },
      attributes: ["id",
        "app_hosts",
        "app_code",
        "app_name",
        "uapp_id",
        "uapp_key",
        "uapp_secret",
        "contact_name",
        "contact_mobile",
        "contact_email",
        "is_enabled",
        "is_sign"],
      raw: true
    });
  }
}
module.exports = AppDao;
