const system = require("../../../system");
const settings = require("../../../../config/settings");
const uiconfig = system.getUiConfig2(settings.appKey);
module.exports = (db, DataTypes) => {
  return db.define("apppayparam", {
    uapp_id: DataTypes.STRING(50),
    pay_appid: DataTypes.STRING(64), //支付商的appid     
    mch_id: DataTypes.STRING(64), //支付商户id    
    pay_key: DataTypes.STRING(64),
    is_enabled: { //状态 0禁用 1启用
      type: DataTypes.BOOLEAN,
      defaultValue: true,
    },
    pay_url: DataTypes.STRING(255), //支付地址     
    notify_url: DataTypes.STRING(500), //支付成功后通知的地址  
    notes: DataTypes.STRING(255),
  }, {
      paranoid: false,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      timestamps: true,
      updatedAt: false,
      tableName: 'p_app_payparam',
      validate: {

      },
      indexes: [

      ]
    });
}
