const system = require("../../../system");
const settings = require("../../../../config/settings");
const uiconfig = system.getUiConfig2(settings.appKey);
module.exports = (db, DataTypes) => {
  return db.define("appuser", {
    uapp_id: DataTypes.INTEGER,
    channel_userid: DataTypes.STRING(64), //渠道用户ID         
    channel_username: DataTypes.STRING(64), //渠道用户登录名  
    channel_nickname: DataTypes.STRING(255),
    open_id: DataTypes.STRING(64), //用户唯一ID（可用与微信唯一ID）        
    head_url: DataTypes.STRING(255),
    mobile: DataTypes.STRING(255),
    org_name: DataTypes.STRING(255),
    org_path: DataTypes.STRING(255),
    email: DataTypes.STRING(50),
    is_admin: {
      type: DataTypes.BOOLEAN,
      defaultValue: false,
    },
    is_super: {
      type: DataTypes.BOOLEAN,
      defaultValue: false,
    },
    is_enabled: {
      type: DataTypes.BOOLEAN,
      defaultValue: true,
    },
    last_login_time: DataTypes.DATE,
  }, {
      paranoid: false,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      timestamps: true,
      updatedAt: false,
      //freezeTableName: true,
      // define the table's name
      tableName: 'p_app_user',
      validate: {

      },
      indexes: [
      ]
    });
}
