const system = require("../../../system");
const settings = require("../../../../config/settings");
const uiconfig = system.getUiConfig2(settings.appKey);
module.exports = (db, DataTypes) => {
  return db.define("productinterface", {
    product_id: DataTypes.INTEGER,
    interface_url: DataTypes.STRING(255), //推送到服务商的产品编码
    req_type: { //请求类型，bd本地，yc远程
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.req_type),
      set: function (val) {
        this.setDataValue("req_type", val);
        this.setDataValue("req_type_name", uiconfig.config.pdict.req_type[val]);
      },
    },
    req_type_name: DataTypes.STRING(255),
    interface_type: { //接口类型sjts商机推送，ddcz订单操作
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.interface_type),
      set: function (val) {
        this.setDataValue("interface_type", val);
        this.setDataValue("interface_type_name", uiconfig.config.pdict.interface_type[val]);
      },
    },
    interface_type_name: DataTypes.STRING(255),
    params: DataTypes.STRING(1024), //参数
    desc: DataTypes.STRING(1024), //描述
  }, {
      paranoid: false,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      timestamps: true,
      updatedAt: false,
      tableName: 'p_product_interface',
      validate: {

      },
      indexes: [

      ]
    });
}
