const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");

class ProductService extends ServiceBase {
  constructor() {
    super("dbproduct", ServiceBase.getDaoName(ProductService));
    this.productpriceDao = system.getObject("db.dbproduct.productpriceDao");
  }
  /**
   * 获取产品详情
   * @param {*} pid 产品id
   */
  async getProductDetailById(pid){
    if(!pid){
      return system.getResult(null, "产品id有误");
    }
    var sql = "select * from v_product where id="+pid;
    var tmpResult = await this.customQuery(sql);
    if(tmpResult && tmpResult.length>0){
      for(var i=0;i<tmpResult.length;i++){
        var pro = tmpResult[i];
        if(pro.id){
          var ppList = await this.productpriceDao.model.findAll({
            where:{product_id:pro.id},
            attributes: ["price","supply_price","service_charge","public_expense","is_default","price_type","price_type_name",
              "sort","price_desc","min_qty","max_qty"
            ],
            raw:true
          });
          pro.productPriceList=ppList;
        }
      }
    }
    return system.getResultSuccess(tmpResult);
  }
  /**
   * 获取产品详情2
   * @param {*} pcode 产品码
   * @param {*} appid 渠道id
   */
  async getProductDetailByCode(pcode,uappid){
    if(!pcode){
      return system.getResult(null, "产品编码有误");
    }
    if(!uappid){
      return system.getResult(null, "渠道编码有误");
    }
    var sql = "select * from v_product where uapp_id="+uappid+" and item_code='"+pcode+"'";
    var tmpResult = await this.customQuery(sql);
    if(tmpResult && tmpResult.length>0){
      for(var i=0;i<tmpResult.length;i++){
        var pro = tmpResult[i];
        if(pro.id){
          var ppList = await this.productpriceDao.model.findAll({
            where:{product_id:pro.id},
            attributes: ["price","supply_price","service_charge","public_expense","is_default","price_type","price_type_name",
              "sort","price_desc","min_qty","max_qty"
            ],
            raw:true
          });
          pro.productPriceList=ppList;
        }
        
      }
    }
    return system.getResultSuccess(tmpResult);
  }

  /**
   * 通过产品类别编码获取产品列表
   * @param {*} obj 
   */
  async findByTypeCode(obj){
    var app=obj.app;
    if(!app || !app.uapp_id){
      return system.getResult(null, "渠道参数有误");
    }
    var typeCode = obj.typeCode;
    if(!typeCode){
      return system.getResult(null, "产品类别编码有误");
    }
    var sql = "select * from v_product where uapp_id="+app.uapp_id+" and type_code='"+typeCode+"'";
    var tmpResult = await this.customQuery(sql);
    return system.getResultSuccess(tmpResult);
  }
  /**
   * 通过产品大类编码获取产品列表
   * @param {*} obj 
   */
  async findByTypeOneCode(obj){
    var app=obj.app;
    if(!app || !app.id){
      return system.getResult(null, "渠道参数有误");
    }
    var typeOneCode = obj.typeOneCode;
    if(!typeOneCode){
      return system.getResult(null, "产品类别编码有误");
    }
    var sql = "select * from v_product where uapp_id="+app.uapp_id+" and p_type_code='"+typeOneCode+"'";
    var tmpResult = await this.customQuery(sql);
    return system.getResultSuccess(tmpResult);
  }
}
module.exports = ProductService;
// var task = new ProductService();
// task.getProductDetailByCode("test002",7).then(d=>{
//   console.log(d,"ddddddddddddddddddddddddddddddddddddddddddddddd");
//   console.log(d.data[0],"eeeee");
// });
