var system = require("../../system")
const md5 = require("MD5");
const uuidv1 = require('uuid/v1');

class GemaApi {
    constructor() {
        this.etemplatebusiSve = system.getObject("service.etemplatebusiSve");
        this.esettleSve = system.getObject("service.esettleSve");
        this.qbgconfigSve = system.getObject("service.qbgconfigSve");
        this.redisLock = system.getObject("util.redisLock");
        this.idcardClient = system.getObject("util.idcardClient");
        this.econtractSve = system.getObject("service.econtractSve");
        this.dkcontractSve = system.getObject("service.dkcontractSve");
    }


    /**
     * 两方电子签
     * @param pobj
     * @returns {Promise<{msg: *, code: *, data: (*|null)}|{msg: *, code: *, data}|*|{msg: *, code: *, data}>}
     */
    async autoSign(pobj) {
        // 处理参数
        var param = {
            ecid: this.trim(pobj.ecid),
            appId: this.trim(pobj.appId),
            userId: this.trim(pobj.userId),
            idName: this.trim(pobj.idName),
            mobile: this.trim(pobj.mobile),
            idNo: this.trim(pobj.idNo),
            bankno: this.trim(pobj.bankno),
            nonceStr: this.trim(pobj.nonceStr),
            sign: this.trim(pobj.sign)
        };

        if (!param.ecid) {
            return this.returnjson(-1, "请传入薪必果提供的ecid")
        }
        if (!param.appId) {
            return this.returnjson(-1, "请传入薪必果提供的appId")
        }
        if (!param.userId) {
            return this.returnjson(-1, "请提供该用户的userId")
        }
        if (!param.idName) {
            return this.returnjson(-1, "请提供该用户姓名")
        }
        if (!param.idNo) {
            return this.returnjson(-1, "请提供该用户身份证号")
        }
        if (!await this.idcardClient.checkIDCard(param.idNo)) {
            return this.returnjson(-1, "身份证格式不正确");
        }

        let card = await this.idcardClient.cardInfo(param.idNo);
        let age = card.age || 0;
        if (!age) {
            return this.returnjson(-1, "身份证号格式错误, 只支持18位身份证号码");
        }
        if (card.sex == 'male') {
            if (age < 18 || age > 60) {
                return this.returnjson(-1, "签约失败，男限制18-60岁之间")
            }
        } else {
            if (age < 18 || age > 55) {
                return this.returnjson(-1, "签约失败，女限制18-55岁之间")
            }
        }

        if (!param.bankno) {
            return this.returnjson(-1, "请提供该用户银行卡号")
        }
        if (!param.nonceStr) {
            return this.returnjson(-1, "请提供随机码")
        }

        // 查appId关联key
        var qbg = await this.qbgconfigSve.findOne({
            appId: param.appId
        });
        if (!qbg || !qbg.key) {
            return this.returnjson(1001003, "配置信息错误，请联系薪必果人员进行配置");
        }

        // 签名
        var signArr = [];
        var keys = Object.keys(param).sort();
        for (var i = 0; i < keys.length; i++) {
            var k = keys[i];
            var v = param[k];
            if (!k || !v || k == 'sign') {
                continue;
            }
            signArr.push(k + "=" + v);
        }
        var signStr = signArr.join("&") + "&key=" + qbg.key;
        var sign = md5(signStr).toUpperCase();
        console.log("---autoSign---签名---", signStr, sign);
        if (param.sign != sign) {
            return this.returnjson(1001001, `签名错误`);
        }
        try {
            param.idNo = param.idNo.toUpperCase();
            param.bankno = param.bankno.replace(/\s*/g, "");
            var key = param.idNo + "_" + param.ecid
            const id = uuidv1();
            await this.redisLock.lock(key, id, 20);
            var result = await this.qbgconfigSve.autoSigns(param, qbg);
            await this.redisLock.unLock(key, id);
            return result;
        } catch (error) {
            console.log(error);
        }
    }


    /**
     * 三方电子签
     */
    // async autoSign(pobj) {
    //     // 处理参数
    //     var param = {
    //         ecid: this.trim(pobj.ecid),
    //         appId: this.trim(pobj.appId),
    //         userId: this.trim(pobj.userId),
    //         idName: this.trim(pobj.idName),
    //         mobile: this.trim(pobj.mobile),
    //         idNo: this.trim(pobj.idNo),
    //         bankno: this.trim(pobj.bankno),
    //         nonceStr: this.trim(pobj.nonceStr),
    //         sign: this.trim(pobj.sign)
    //     };
    //
    //     if (!param.ecid) {
    //         return this.returnjson(-1, "请传入薪必果提供的ecid")
    //     }
    //     if (!param.appId) {
    //         return this.returnjson(-1, "请传入薪必果提供的appId")
    //     }
    //     if (!param.userId) {
    //         return this.returnjson(-1, "请提供该用户的userId")
    //     }
    //     if (!param.idName) {
    //         return this.returnjson(-1, "请提供该用户姓名")
    //     }
    //     if (!param.idNo) {
    //         return this.returnjson(-1, "请提供该用户身份证号")
    //     }
    //     if (!await this.idcardClient.checkIDCard(param.idNo)) {
    //         return this.returnjson(-1, "身份证格式不正确");
    //     }
    //
    //     let card = await this.idcardClient.cardInfo(param.idNo);
    //     let age = card.age || 0;
    //     if (!age) {
    //         return this.returnjson(-1, "身份证号格式错误, 只支持18位身份证号码");
    //     }
    //     if (card.sex == 'male') {
    //         if (age < 18 || age > 60) {
    //             return this.returnjson(-1, "签约失败，男限制18-60岁之间")
    //         }
    //     } else {
    //         if (age < 18 || age > 55) {
    //             return this.returnjson(-1, "签约失败，女限制18-55岁之间")
    //         }
    //     }
    //
    //     if (!param.bankno) {
    //         return this.returnjson(-1, "请提供该用户银行卡号")
    //     }
    //     if (!param.nonceStr) {
    //         return this.returnjson(-1, "请提供随机码")
    //     }
    //
    //     // 查appId关联key
    //     var qbg = await this.qbgconfigSve.findOne({
    //         appId: param.appId
    //     });
    //     if (!qbg || !qbg.key) {
    //         return this.returnjson(1001003, "配置信息错误，请联系薪必果人员进行配置");
    //     }
    //
    //     // 签名
    //     var signArr = [];
    //     var keys = Object.keys(param).sort();
    //     for (var i = 0; i < keys.length; i++) {
    //         var k = keys[i];
    //         var v = param[k];
    //         if (!k || !v || k == 'sign') {
    //             continue;
    //         }
    //         signArr.push(k + "=" + v);
    //     }
    //     var signStr = signArr.join("&") + "&key=" + qbg.key;
    //     var sign = md5(signStr).toUpperCase();
    //     console.log("---autoSign---签名---", signStr, sign);
    //     if (param.sign != sign) {
    //         return this.returnjson(1001001, `签名错误`);
    //     }
    //
    //     try {
    //         param.idNo = param.idNo.toUpperCase();
    //         param.bankno = param.bankno.replace(/\s*/g, "");
    //         var key = param.idNo + "_" + param.ecid
    //         const id = uuidv1();
    //         await this.redisLock.lock(key, id, 20);
    //         var result = await this.qbgconfigSve.autoSign(param,qbg);
    //         await this.redisLock.unLock(key, id);
    //         return result;
    //     } catch (error) {
    //         console.log(error);
    //     }
    // }


    async sinedUser(obj, req) {
        // 验证合法性
        let appId = obj.appId;
        let nonceStr = obj.nonceStr;
        let ecid = obj.ecid || "";
        let idNo = obj.idNo;

        let busi = await this.qbgconfigSve.findOne({
            appId: appId
        });
        if (!busi) {
            return {
                code: 1001003,
                msg: "配置信息错误，请联系薪必果人员进行配置"
            };
        }

        let signArr = [];
        signArr.push("appId=" + appId);
        signArr.push("ecid=" + ecid);
        signArr.push("idNo=" + idNo);
        signArr.push("nonceStr=" + nonceStr);
        signArr.push("key=" + busi.key);
        let signStr = signArr.join("&")
        let sign = md5(signStr).toUpperCase();
        console.log(signStr, sign);

        if (sign != obj.sign) {
            return {
                code: 1001001,
                msg: "签名失败"
            };
        }
        let params = {
            dktemplate_id: ecid,
            idNo: idNo.toUpperCase(),
        };

        try {
            let user = await this.dkcontractSve.findSingleSignedUser(params);
            let result = {
                code: 0,
                msg: "success",
                data: user
            };
            return result;
        } catch (e) {
            let result = {
                code: 500,
                msg: "接口异常"
            };
            console.log(e.stack);
            return result;
        }
    }


    trim(o) {
        if (!o) {
            return "";
        }
        return o.toString().trim();
    }

    returnjson(code, msg, data) {
        return {
            code: code,
            msg: msg,
            data: data || null
        }
    }

}

module.exports = GemaApi;
