var system = require("../../system")
var settings = require("../../../config/settings");
const CtlBase = require("../ctl.base");
const uuidv4 = require('uuid/v4');
const moment = require('moment');
const md5 = require("MD5");

class ecompanywxuserCtl extends CtlBase {
  constructor() {
    super(CtlBase.getServiceName(ecompanywxuserCtl));
    this.idcardClient = system.getObject("util.idcardClient");

    this.ecompanySve = system.getObject("service.ecompanySve");
    this.etemplateSve = system.getObject("service.etemplateSve");
    this.ecompanybusiSve = system.getObject("service.ecompanybusiSve");
    this.redisClient = system.getObject("util.redisClient");
  }

  // 通过用户id保存用户，目前只有北京酷酷在用
  async saveuser(q, p, req) {
    try {
      if(!await this.idcardClient.checkIDCard(p.id_no)) {
        return system.getErrResult2("您的身份证号格式错误");
      }

      p.id_no = p.id_no.toUpperCase();
      var wxuser = {
        ecompany_id: Number(p.ecompany_id),
        openId: this.trim(p.openId),
        id_no: this.trim(p.id_no),
        id_name: this.trim(p.id_name),
        userCode: this.trim(p.userCode),
        isSend: false,
      };

      var rs = await this.service.savewxuser(wxuser);
      if(rs == -101) {
        return system.getErrResult2("公司还未配置签约参数");
      }
      if(rs == -102) {
        return system.getErrResult2("您的身份证号格式错误, 只支持18位身份证号码");
      }
      if(rs == -103) {
        return system.getErrResult2("签约失败，男限制18-60岁之间");
      }
      if(rs == -104) {
        return system.getErrResult2("签约失败，女限制18-55岁之间");
      }
      if(rs == -105){
        return system.getErrResult2("推送异常");
      }

      if(rs == -201) {
        return system.getErrResult2("提交失败，您填写的身份证号码已经录入系统");
      }

      if(rs.code !== 0){
        return system.getErrResult2(rs.message);
      }
      return system.getResult2(rs);

    } catch (e) {
      console.log(e);
      return system.getErrResult2("您的网络不稳, 请稍后重试");
    }
  }

  // 通过模板id保存用户
  async saveEcidUser(q, p, req) {
    var etemplate_id = Number(p.etemplate_id);
    try {
      var template = await this.etemplateSve.findById(etemplate_id);
      var wxuser = {
        ecompany_id: Number(template.ecompany_id || 0),
        etemplate_id: Number(etemplate_id || 0),
        openId: this.trim(p.openId),
        id_no: this.trim(p.id_no || ""),
        id_name: this.trim(p.id_name || ""),
        userCode: this.trim(p.userCode || ""),
        isSend: false,
      };

      var rs = await this.service.saveEcidUser(wxuser);
      if(rs == -101) {
        return system.getErrResult2("公司还未配置签约参数");
      }

      if(rs == -201) {
        return system.getErrResult2("提交失败，您填写的身份证号码已经录入系统");
      }
      return system.getResult2(rs);
    } catch (e) {
      console.log(e);
      return system.getErrResult2("您的网络不稳, 请稍后重试");
    }
  }

  async companyName(q, p, req) {
    var ecompany_id = Number(p.companyId);
    try {
      var ecompany = await this.ecompanySve.findById(ecompany_id);
      if(!ecompany) {
        return system.getErrResult2("公司名称未设置");
      }
      return system.getResult2(ecompany.name);
    } catch (e) {
      console.log(e);
      return system.getErrResult2("您的网络不稳, 请稍后重试");
    }
  }

  async companyByEcid(q, p, req) {
    var ecid = Number(p.ecid);
    try {
      var etemplate = await this.etemplateSve.findById(ecid);
      var ecompany = await this.ecompanySve.findById(etemplate.ecompany_id);

      if(!ecompany || !etemplate) {
        return system.getErrResult2("公司未设置");
      }
      ecompany.etemplate = etemplate;
      return system.getResult2(ecompany);
    } catch (e) {
      console.log(e);
      return system.getErrResult2("您的网络不稳, 请稍后重试");
    }
  }

  // 跟拒ecompany_id验证签名
  async validateSign(q, p, req) {
    try {
      var sign = p.sign || "";
      var companyId = p.companyId || 0;
      var nonceStr = p.nonceStr || "";
      var userCode = p.userCode || "";
      var busi = await this.ecompanybusiSve.findOne({ecompany_id: companyId});
      if(!busi) {
        return system.getErrResult2("企业未做业务开通");
      }
      var signArr = [];
      signArr.push("appId=" + busi.appId);
      signArr.push("nonceStr=" + nonceStr);
      signArr.push("userCode=" + userCode);
      signArr.push("key=" + busi.key);
      var calcSign = md5(signArr.join("&")).toUpperCase();
      if(sign != calcSign) {
        return system.getErrResult2("签名失败，请关闭页面重试。");
      }

      return system.getResult2(1);
    } catch (e) {
      console.log(e);
      return system.getErrResult2("您的网络不稳, 请稍后重试");
    }
  }

  // 跟拒etemplate_id验证签名
  async validateECSign(q, p, req) {
    try {
      var sign = p.sign || "";
      var etemplateId = p.ecid || 0;
      var nonceStr = p.nonceStr || "";
      var userCode = p.userCode || "";
      var busi = await this.ecompanybusiSve.findOne({etemplate_id: etemplateId});
      if(!busi) {
        return system.getErrResult2("企业未做业务开通");
      }
      var signArr = [];
      signArr.push("appId=" + busi.appId);
      signArr.push("nonceStr=" + nonceStr);
      signArr.push("userCode=" + userCode);
      signArr.push("key=" + busi.key);
      var calcSign = md5(signArr.join("&")).toUpperCase();
      if(sign != calcSign) {
        return system.getErrResult2("签名失败，请关闭页面重试。");
      }

      return system.getResult2(1);
    } catch (e) {
      console.log(e);
      return system.getErrResult2("您的网络不稳, 请稍后重试");
    }
  }
}
module.exports = ecompanywxuserCtl;
